/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Method;
import junitparams.internal.DescribableFrameworkMethod;
import junitparams.internal.MethodBlockSupplier;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

public abstract class InvokableFrameworkMethod
extends DescribableFrameworkMethod {
    private final Description description;

    InvokableFrameworkMethod(Method method, Description description) {
        super(method);
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    public abstract Statement getInvokeStatement(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMethodInvoker(RunNotifier notifier, Statement methodInvoker, Description methodWithParams) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, methodWithParams);
        eachNotifier.fireTestStarted();
        try {
            methodInvoker.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    public abstract void run(MethodBlockSupplier var1, RunNotifier var2);
}

