/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import junitparams.internal.DescribableFrameworkMethod;
import junitparams.internal.InstanceFrameworkMethod;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;

public class ParameterisedFrameworkMethod
extends DescribableFrameworkMethod
implements Filterable {
    private final Description baseDescription;
    private List<InstanceFrameworkMethod> instanceMethods;
    private Description description;

    public ParameterisedFrameworkMethod(Method method, Description baseDescription, List<InstanceFrameworkMethod> instanceMethods) {
        super(method);
        this.baseDescription = baseDescription;
        this.instanceMethods = instanceMethods;
    }

    @Override
    public Description getDescription() {
        if (this.description == null) {
            this.description = this.baseDescription.childlessCopy();
            for (InstanceFrameworkMethod instanceMethod : this.instanceMethods) {
                this.description.addChild(instanceMethod.getInstanceDescription());
            }
        }
        return this.description;
    }

    public List<InstanceFrameworkMethod> getMethods() {
        return this.instanceMethods;
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        int count = this.instanceMethods.size();
        Iterator<InstanceFrameworkMethod> i = this.instanceMethods.iterator();
        while (i.hasNext()) {
            InstanceFrameworkMethod instanceMethod = i.next();
            if (filter.shouldRun(instanceMethod.getInstanceDescription())) {
                try {
                    filter.apply(instanceMethod);
                }
                catch (NoTestsRemainException e) {
                    i.remove();
                }
                continue;
            }
            i.remove();
        }
        if (this.instanceMethods.size() != count) {
            this.description = null;
        }
        if (this.instanceMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }
}

