/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junitparams.internal.DeferredErrorFrameworkMethod;
import junitparams.internal.DescribableFrameworkMethod;
import junitparams.internal.InstanceFrameworkMethod;
import junitparams.internal.NonParameterisedFrameworkMethod;
import junitparams.internal.ParameterisedFrameworkMethod;
import junitparams.internal.Utils;
import junitparams.internal.annotation.FrameworkMethodAnnotations;
import junitparams.internal.parameters.ParametersReader;
import junitparams.naming.MacroSubstitutionNamingStrategy;
import junitparams.naming.TestCaseNamingStrategy;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    private FrameworkMethod frameworkMethod;
    private FrameworkMethodAnnotations frameworkMethodAnnotations;
    private Class<?> testClass;
    private ParametersReader parametersReader;
    private Object[] cachedParameters;
    private TestCaseNamingStrategy namingStrategy;
    private DescribableFrameworkMethod describableFrameworkMethod;

    public TestMethod(FrameworkMethod method, TestClass testClass) {
        this.frameworkMethod = method;
        this.testClass = testClass.getJavaClass();
        this.frameworkMethodAnnotations = new FrameworkMethodAnnotations(method);
        this.parametersReader = new ParametersReader(this.testClass(), this.frameworkMethod);
        this.namingStrategy = new MacroSubstitutionNamingStrategy(this);
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    public static List<FrameworkMethod> listFrom(TestClass testClass) {
        ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod frameworkMethod : testClass.getAnnotatedMethods(Test.class)) {
            TestMethod testMethod = new TestMethod(frameworkMethod, testClass);
            methods.add(testMethod.describableFrameworkMethod());
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TestMethod && this.hasTheSameNameAsFrameworkMethod((TestMethod)obj) && this.hasTheSameParameterTypesAsFrameworkMethod((TestMethod)obj);
    }

    private boolean hasTheSameNameAsFrameworkMethod(TestMethod testMethod) {
        return this.frameworkMethod.getName().equals(testMethod.frameworkMethod.getName());
    }

    private boolean hasTheSameParameterTypesAsFrameworkMethod(TestMethod testMethod) {
        Object[] frameworkMethodParameterTypes = this.frameworkMethod.getMethod().getParameterTypes();
        Object[] testMethodParameterTypes = testMethod.frameworkMethod.getMethod().getParameterTypes();
        return Arrays.equals(frameworkMethodParameterTypes, testMethodParameterTypes);
    }

    private Class<?> testClass() {
        return this.testClass;
    }

    private boolean isIgnored() {
        return this.hasIgnoredAnnotation() || this.hasNoParameters();
    }

    private boolean hasIgnoredAnnotation() {
        return this.frameworkMethodAnnotations.hasAnnotation(Ignore.class);
    }

    private boolean hasNoParameters() {
        return this.isParameterised() && this.parametersSets().length == 0;
    }

    private boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.frameworkMethodAnnotations.getAnnotation(annotationType);
    }

    private Description getDescription(Object[] params, int i) {
        Object paramSet = params[i];
        String name = this.namingStrategy.getTestCaseName(i, paramSet);
        String uniqueMethodId = Utils.uniqueMethodId(i, paramSet, this.name());
        return Description.createTestDescription(this.testClass().getName(), name, (Serializable)((Object)uniqueMethodId));
    }

    DescribableFrameworkMethod describableFrameworkMethod() {
        if (this.describableFrameworkMethod == null) {
            Description baseDescription = Description.createTestDescription(this.testClass, this.name(), this.frameworkMethodAnnotations.allAnnotations());
            Method method = this.frameworkMethod.getMethod();
            try {
                this.describableFrameworkMethod = this.createDescribableFrameworkMethod(method, baseDescription);
            }
            catch (IllegalStateException e) {
                this.describableFrameworkMethod = new DeferredErrorFrameworkMethod(method, baseDescription, e);
            }
        }
        return this.describableFrameworkMethod;
    }

    private DescribableFrameworkMethod createDescribableFrameworkMethod(Method method, Description baseDescription) {
        if (this.isParameterised()) {
            if (this.isNotIgnored()) {
                Object[] parametersSets = this.parametersSets();
                ArrayList<InstanceFrameworkMethod> methods = new ArrayList<InstanceFrameworkMethod>();
                for (int i = 0; i < parametersSets.length; ++i) {
                    Object parametersSet = parametersSets[i];
                    Description description = this.getDescription(parametersSets, i);
                    methods.add(new InstanceFrameworkMethod(method, baseDescription.childlessCopy(), description, parametersSet));
                }
                return new ParameterisedFrameworkMethod(method, baseDescription, methods);
            }
            this.warnIfNoParamsGiven();
        } else {
            this.verifyMethodCanBeRunByStandardRunner(this.frameworkMethod);
        }
        return new NonParameterisedFrameworkMethod(method, baseDescription, this.isIgnored());
    }

    private void verifyMethodCanBeRunByStandardRunner(FrameworkMethod method) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        method.validatePublicVoidNoArg(false, errors);
        if (!errors.isEmpty()) {
            throw new RuntimeException((Throwable)errors.get(0));
        }
    }

    public Object[] parametersSets() {
        if (this.cachedParameters == null) {
            this.cachedParameters = this.parametersReader.read();
        }
        return this.cachedParameters;
    }

    private void warnIfNoParamsGiven() {
        if (this.isNotIgnored() && this.isParameterised() && this.parametersSets().length == 0) {
            System.err.println("Method " + this.name() + " gets empty list of parameters, so it's being ignored!");
        }
    }

    public FrameworkMethod frameworkMethod() {
        return this.frameworkMethod;
    }

    boolean isParameterised() {
        return this.frameworkMethodAnnotations.isParametrised();
    }
}

