/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import java.io.IOException;
import java.io.InputStream;
import org.brotli.dec.BrotliRuntimeException;
import org.brotli.dec.Decode;
import org.brotli.dec.State;

public class BrotliInputStream
extends InputStream {
    public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 256;
    private byte[] buffer;
    private int remainingBufferBytes;
    private int bufferOffset;
    private final State state = new State();

    public BrotliInputStream(InputStream source) throws IOException {
        this(source, 256);
    }

    public BrotliInputStream(InputStream source, int byteReadBufferSize) throws IOException {
        if (byteReadBufferSize <= 0) {
            throw new IllegalArgumentException("Bad buffer size:" + byteReadBufferSize);
        }
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        this.buffer = new byte[byteReadBufferSize];
        this.remainingBufferBytes = 0;
        this.bufferOffset = 0;
        try {
            Decode.initState(this.state, source);
        }
        catch (BrotliRuntimeException ex) {
            throw new IOException("Brotli decoder initialization failed", ex);
        }
    }

    public void attachDictionaryChunk(byte[] data) {
        Decode.attachDictionaryChunk(this.state, data);
    }

    public void enableEagerOutput() {
        Decode.enableEagerOutput(this.state);
    }

    public void enableLargeWindow() {
        Decode.enableLargeWindow(this.state);
    }

    @Override
    public void close() throws IOException {
        Decode.close(this.state);
    }

    @Override
    public int read() throws IOException {
        if (this.bufferOffset >= this.remainingBufferBytes) {
            this.remainingBufferBytes = this.read(this.buffer, 0, this.buffer.length);
            this.bufferOffset = 0;
            if (this.remainingBufferBytes == -1) {
                return -1;
            }
        }
        return this.buffer[this.bufferOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] destBuffer, int destOffset, int destLen) throws IOException {
        if (destOffset < 0) {
            throw new IllegalArgumentException("Bad offset: " + destOffset);
        }
        if (destLen < 0) {
            throw new IllegalArgumentException("Bad length: " + destLen);
        }
        if (destOffset + destLen > destBuffer.length) {
            throw new IllegalArgumentException("Buffer overflow: " + (destOffset + destLen) + " > " + destBuffer.length);
        }
        if (destLen == 0) {
            return 0;
        }
        int copyLen = Math.max(this.remainingBufferBytes - this.bufferOffset, 0);
        if (copyLen != 0) {
            copyLen = Math.min(copyLen, destLen);
            System.arraycopy(this.buffer, this.bufferOffset, destBuffer, destOffset, copyLen);
            this.bufferOffset += copyLen;
            destOffset += copyLen;
            if ((destLen -= copyLen) == 0) {
                return copyLen;
            }
        }
        try {
            this.state.output = destBuffer;
            this.state.outputOffset = destOffset;
            this.state.outputLength = destLen;
            this.state.outputUsed = 0;
            Decode.decompress(this.state);
            if (this.state.outputUsed == 0) {
                return -1;
            }
            return this.state.outputUsed + copyLen;
        }
        catch (BrotliRuntimeException ex) {
            throw new IOException("Brotli stream decoding failed", ex);
        }
    }
}

