/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import java.nio.ByteBuffer;
import org.brotli.dec.BrotliRuntimeException;

public final class Dictionary {
    static final int MIN_DICTIONARY_WORD_LENGTH = 4;
    static final int MAX_DICTIONARY_WORD_LENGTH = 31;
    private static ByteBuffer data;
    static final int[] offsets;
    static final int[] sizeBits;

    public static void setData(ByteBuffer data, int[] sizeBits) {
        int i;
        if (!data.isDirect() || !data.isReadOnly()) {
            throw new BrotliRuntimeException("data must be a direct read-only byte buffer");
        }
        if (sizeBits.length > 31) {
            throw new BrotliRuntimeException("sizeBits length must be at most 31");
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (sizeBits[i2] == 0) continue;
            throw new BrotliRuntimeException("first 4 must be 0");
        }
        int[] dictionaryOffsets = offsets;
        int[] dictionarySizeBits = Dictionary.sizeBits;
        System.arraycopy(sizeBits, 0, dictionarySizeBits, 0, sizeBits.length);
        int pos = 0;
        int limit = data.capacity();
        for (i = 0; i < sizeBits.length; ++i) {
            dictionaryOffsets[i] = pos;
            int bits = dictionarySizeBits[i];
            if (bits == 0) continue;
            if (bits >= 31) {
                throw new BrotliRuntimeException("sizeBits values must be less than 31");
            }
            if ((pos += i << bits) > 0 && pos <= limit) continue;
            throw new BrotliRuntimeException("sizeBits is inconsistent: overflow");
        }
        for (i = sizeBits.length; i < 32; ++i) {
            dictionaryOffsets[i] = pos;
        }
        if (pos != limit) {
            throw new BrotliRuntimeException("sizeBits is inconsistent: underflow");
        }
        Dictionary.data = data;
    }

    public static ByteBuffer getData() {
        if (data != null) {
            return data;
        }
        if (!DataLoader.OK) {
            throw new BrotliRuntimeException("brotli dictionary is not set");
        }
        return data;
    }

    static {
        offsets = new int[32];
        sizeBits = new int[32];
    }

    private static class DataLoader {
        static final boolean OK;

        private DataLoader() {
        }

        static {
            boolean ok = true;
            try {
                Class.forName(Dictionary.class.getPackage().getName() + ".DictionaryData");
            }
            catch (Throwable ex) {
                ok = false;
            }
            OK = ok;
        }
    }
}

