/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import org.brotli.dec.BrotliRuntimeException;

final class Utils {
    private static final byte[] BYTE_ZEROES = new byte[1024];
    private static final int[] INT_ZEROES = new int[1024];

    Utils() {
    }

    static void fillBytesWithZeroes(byte[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(BYTE_ZEROES, 0, dest, cursor, step);
        }
    }

    static void fillIntsWithZeroes(int[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(INT_ZEROES, 0, dest, cursor, step);
        }
    }

    static void copyBytes(byte[] dst, int target, byte[] src, int start, int end) {
        System.arraycopy(src, start, dst, target, end - start);
    }

    static void copyBytesWithin(byte[] bytes, int target, int start, int end) {
        System.arraycopy(bytes, start, bytes, target, end - start);
    }

    static int readInput(InputStream src, byte[] dst, int offset, int length) {
        try {
            return src.read(dst, offset, length);
        }
        catch (IOException e) {
            throw new BrotliRuntimeException("Failed to read input", e);
        }
    }

    static void closeInput(InputStream src) throws IOException {
        src.close();
    }

    static byte[] toUsAsciiBytes(String src) {
        try {
            return src.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    static int isDebugMode() {
        boolean assertsEnabled = Boolean.parseBoolean(System.getProperty("BROTLI_ENABLE_ASSERTS"));
        return assertsEnabled ? 1 : 0;
    }

    static int getLogBintness() {
        boolean isLongExpensive = Boolean.parseBoolean(System.getProperty("BROTLI_32_BIT_CPU"));
        return isLongExpensive ? 5 : 6;
    }
}

