/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.integration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.brotli.dec.BrotliInputStream;
import org.brotli.integration.BundleHelper;

public class BundleChecker
implements Runnable {
    private final AtomicInteger nextJob;
    private final InputStream input;
    private final boolean sanityCheck;

    public BundleChecker(InputStream input, AtomicInteger nextJob, boolean sanityCheck) {
        this.input = input;
        this.nextJob = nextJob;
        this.sanityCheck = sanityCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long decompressAndCalculateCrc(ZipInputStream input) throws IOException {
        long crc;
        FilterInputStream entryStream = new FilterInputStream(input){

            @Override
            public void close() {
            }
        };
        try (BrotliInputStream decompressedStream = new BrotliInputStream(entryStream);){
            crc = BundleHelper.fingerprintStream(decompressedStream);
        }
        return crc;
    }

    @Override
    public void run() {
        String entryName = "";
        ZipInputStream zis = new ZipInputStream(this.input);
        try {
            ZipEntry entry;
            int entryIndex = 0;
            int jobIndex = this.nextJob.getAndIncrement();
            while ((entry = zis.getNextEntry()) != null) {
                block7: {
                    if (entry.isDirectory()) continue;
                    if (entryIndex++ != jobIndex) {
                        zis.closeEntry();
                        continue;
                    }
                    entryName = entry.getName();
                    long entryCrc = BundleHelper.getExpectedFingerprint(entryName);
                    try {
                        if (entryCrc != this.decompressAndCalculateCrc(zis) && !this.sanityCheck) {
                            throw new RuntimeException("CRC mismatch");
                        }
                    }
                    catch (IOException iox) {
                        if (this.sanityCheck) break block7;
                        throw new RuntimeException("Decompression failed", iox);
                    }
                }
                zis.closeEntry();
                entryName = "";
                jobIndex = this.nextJob.getAndIncrement();
            }
            zis.close();
            this.input.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(entryName, ex);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        int argsOffset = 0;
        boolean sanityCheck = false;
        if (args.length != 0 && args[0].equals("-s")) {
            sanityCheck = true;
            argsOffset = 1;
        }
        if (args.length == argsOffset) {
            throw new RuntimeException("Usage: BundleChecker [-s] <fileX.zip> ...");
        }
        for (int i = argsOffset; i < args.length; ++i) {
            new BundleChecker(new FileInputStream(args[i]), new AtomicInteger(0), sanityCheck).run();
        }
    }
}

