/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.integration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BundleHelper {
    private static final long CRC_64_POLY = new BigInteger("C96C5795D7870F42", 16).longValue();

    private BundleHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listEntries(InputStream input) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(input);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    result.add(entry.getName());
                }
                zis.closeEntry();
            }
        }
        return result;
    }

    public static byte[] readStream(InputStream input) throws IOException {
        int bytesRead;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while ((bytesRead = input.read(buffer)) != -1) {
            result.write(buffer, 0, bytesRead);
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readEntry(InputStream input, String entryName) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(input);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals(entryName)) {
                    byte[] result = BundleHelper.readStream(zis);
                    zis.closeEntry();
                    byte[] byArray = result;
                    return byArray;
                }
                zis.closeEntry();
            }
        }
        return null;
    }

    public static long updateCrc64(long crc, byte[] data, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            long c = (crc ^ (long)(data[i] & 0xFF)) & 0xFFL;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1L) == 1L ? CRC_64_POLY ^ c >>> 1 : c >>> 1;
            }
            crc = c ^ crc >>> 8;
        }
        return crc;
    }

    public static long fingerprintStream(InputStream input) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        long crc = -1L;
        while ((len = input.read(buffer)) > 0) {
            crc = BundleHelper.updateCrc64(crc, buffer, 0, len);
        }
        return crc ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long getExpectedFingerprint(String entryName) {
        int dotIndex = entryName.indexOf(46);
        String entryCrcString = dotIndex == -1 ? entryName : entryName.substring(0, dotIndex);
        return new BigInteger(entryCrcString, 16).longValue();
    }
}

