/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.wrapper.dec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.brotli.wrapper.dec.Decoder;

public class BrotliInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final Decoder decoder;

    public BrotliInputStream(InputStream source, int bufferSize) throws IOException {
        this.decoder = new Decoder(Channels.newChannel(source), bufferSize);
    }

    public BrotliInputStream(InputStream source) throws IOException {
        this(source, 16384);
    }

    public void enableEagerOutput() {
        this.decoder.enableEagerOutput();
    }

    @Override
    public void close() throws IOException {
        this.decoder.close();
    }

    @Override
    public int available() {
        return this.decoder.buffer != null ? this.decoder.buffer.remaining() : 0;
    }

    @Override
    public int read() throws IOException {
        int decoded;
        if (this.decoder.closed) {
            throw new IOException("read after close");
        }
        while ((decoded = this.decoder.decode()) == 0) {
        }
        if (decoded == -1) {
            return -1;
        }
        return this.decoder.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.decoder.closed) {
            throw new IOException("read after close");
        }
        if (this.decoder.decode() == -1) {
            return -1;
        }
        int result = 0;
        while (len > 0) {
            int limit = Math.min(len, this.decoder.buffer.remaining());
            this.decoder.buffer.get(b, off, limit);
            off += limit;
            len -= limit;
            result += limit;
            if (this.decoder.decode() != -1) continue;
            break;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.decoder.closed) {
            throw new IOException("read after close");
        }
        long result = 0L;
        while (n > 0L && this.decoder.decode() != -1) {
            int limit = (int)Math.min(n, (long)this.decoder.buffer.remaining());
            this.decoder.discard(limit);
            result += (long)limit;
            n -= (long)limit;
        }
        return result;
    }
}

