/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal;

import java.util.AbstractList;
import java.util.Collection;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.CommandParser;
import org.jacoco.cli.internal.commands.AllCommands;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class CommandHandler
extends OptionHandler<Command> {
    public CommandHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter) {
        super(parser, new OptionDef(AllCommands.names(), "<command>", option.required(), option.help(), option.hidden(), CommandHandler.class, option.isMultiValued()){}, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String subCmd = params.getParameter(0);
        for (Command c : AllCommands.get()) {
            if (!c.name().equals(subCmd)) continue;
            this.parseSubArguments(c, params);
            this.setter.addValue(c);
            return params.size();
        }
        throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND.format(this.option.toString(), subCmd));
    }

    private void parseSubArguments(Command c, final Parameters params) throws CmdLineException {
        CommandParser p = new CommandParser(c);
        p.parseArgument((Collection<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                try {
                    return params.getParameter(index + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params.size() - 1;
            }
        });
    }

    @Override
    public String getDefaultMetaVariable() {
        return "<command>";
    }
}

