/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.CommandParser;
import org.jacoco.cli.internal.commands.AllCommands;
import org.jacoco.report.internal.xml.XMLElement;
import org.kohsuke.args4j.spi.OptionHandler;

public final class XmlDocumentation {
    private XmlDocumentation() {
    }

    private static void writeCommand(Command command, XMLElement parent) throws IOException {
        CommandParser parser = new CommandParser(command);
        XMLElement element = parent.element("command");
        element.attr("name", command.name());
        element.element("usage").text(command.usage(parser));
        element.element("description").text(command.description());
        XmlDocumentation.writeOptions(element, parser.getArguments());
        XmlDocumentation.writeOptions(element, parser.getOptions());
    }

    private static void writeOptions(XMLElement parent, List<OptionHandler> list2) throws IOException {
        for (OptionHandler o : list2) {
            XMLElement optionNode = parent.element("option");
            optionNode.attr("required", String.valueOf(o.option.required()));
            optionNode.attr("multiple", String.valueOf(o.setter.isMultiValued()));
            optionNode.element("usage").text(o.getNameAndMeta(null));
            optionNode.element("description").text(o.option.usage());
        }
    }

    public static void main(String ... args) throws IOException {
        File file2 = new File(args[0]);
        file2.getParentFile().mkdirs();
        XMLElement root = new XMLElement("documentation", null, null, true, "UTF-8", new FileOutputStream(file2));
        for (Command c : AllCommands.get()) {
            XmlDocumentation.writeCommand(c, root);
        }
        root.close();
    }
}

