/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.kohsuke.args4j.Argument;

public class ExecInfo
extends Command {
    @Argument(usage="list of JaCoCo *.exec files to read", metaVar="<execfiles>")
    List<File> execfiles = new ArrayList<File>();

    @Override
    public String description() {
        return "Print exec file content in human readable format.";
    }

    @Override
    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        if (this.execfiles.isEmpty()) {
            out.println("[WARN] No execution data files provided.");
        } else {
            for (File file2 : this.execfiles) {
                this.dump(file2, out);
            }
        }
        return 0;
    }

    private void dump(File file2, final PrintWriter out) throws IOException {
        out.printf("[INFO] Loading exec file %s.%n", file2);
        out.println("CLASS ID         HITS/PROBES   CLASS NAME");
        FileInputStream in = new FileInputStream(file2);
        ExecutionDataReader reader = new ExecutionDataReader(in);
        reader.setSessionInfoVisitor(new ISessionInfoVisitor(){

            @Override
            public void visitSessionInfo(SessionInfo info) {
                out.printf("Session \"%s\": %s - %s%n", info.getId(), new Date(info.getStartTimeStamp()), new Date(info.getDumpTimeStamp()));
            }
        });
        reader.setExecutionDataVisitor(new IExecutionDataVisitor(){

            @Override
            public void visitClassExecution(IExecutionData data) {
                out.printf("%016x  %3d of %3d   %s%n", data.getId(), ExecInfo.this.getHitCount(data.getProbesCopy()), data.getProbeCount(), data.getName());
            }
        });
        reader.read();
        in.close();
        out.println();
    }

    private int getHitCount(boolean[] data) {
        int count = 0;
        for (boolean hit : data) {
            if (!hit) continue;
            ++count;
        }
        return count;
    }
}

