/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.core.tools.ExecFileLoader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class Merge
extends Command {
    @Argument(usage="list of JaCoCo *.exec files to read", metaVar="<execfiles>")
    List<File> execfiles = new ArrayList<File>();
    @Option(name="--destfile", usage="file to write merged execution data to", metaVar="<path>", required=true)
    File destfile;

    @Override
    public String description() {
        return "Merges multiple exec files into a new one.";
    }

    @Override
    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        ExecFileLoader loader = this.loadExecutionData(out);
        out.printf("[INFO] Writing execution data to %s.%n", this.destfile.getAbsolutePath());
        loader.save(this.destfile, true);
        return 0;
    }

    private ExecFileLoader loadExecutionData(PrintWriter out) throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        if (this.execfiles.isEmpty()) {
            out.println("[WARN] No execution data files provided.");
        } else {
            for (File file2 : this.execfiles) {
                out.printf("[INFO] Loading execution data file %s.%n", file2.getAbsolutePath());
                loader.load(file2);
            }
        }
        return loader;
    }
}

