/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.util.Arrays;
import org.jacoco.core.data.IExecutionData;

public final class ExecutionData
implements IExecutionData {
    private final long id;
    private final String name;
    private final boolean[] probes;

    public ExecutionData(long id, String name, boolean[] probes) {
        this.id = id;
        this.name = name;
        this.probes = probes;
    }

    public ExecutionData(long id, String name, int probeCount) {
        this.id = id;
        this.name = name;
        this.probes = new boolean[probeCount];
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean[] getProbesCopy() {
        return Arrays.copyOf(this.probes, this.probes.length);
    }

    @Override
    public int getProbeCount() {
        return this.probes.length;
    }

    @Override
    public boolean getProbe(int index) {
        return this.probes[index];
    }

    @Override
    public void setProbe(int index) {
        this.probes[index] = true;
    }

    @Override
    public void reset() {
        Arrays.fill(this.probes, false);
    }

    @Override
    public boolean hasHits() {
        for (boolean p : this.probes) {
            if (!p) continue;
            return true;
        }
        return false;
    }

    @Override
    public void merge(IExecutionData other) {
        this.merge(other, true);
    }

    @Override
    public void merge(IExecutionData other, boolean flag) {
        this.assertCompatibility(other.getId(), other.getName(), other.getProbeCount());
        boolean[] otherData = other.getProbesCopy();
        for (int i = 0; i < this.probes.length; ++i) {
            if (!otherData[i]) continue;
            this.probes[i] = flag;
        }
    }

    @Override
    public void assertCompatibility(long id, String name, int probecount) throws IllegalStateException {
        if (this.id != id) {
            throw new IllegalStateException(String.format("Different ids (%016x and %016x).", this.id, id));
        }
        if (!this.name.equals(name)) {
            throw new IllegalStateException(String.format("Different class names %s and %s for id %016x.", this.name, name, id));
        }
        if (this.probes.length != probecount) {
            throw new IllegalStateException(String.format("Incompatible execution data for class %s with id %016x.", name, id));
        }
    }

    public String toString() {
        return String.format("ExecutionData[name=%s, id=%016x]", this.name, this.id);
    }
}

