/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.MappedExecutionData;

public class ExecutionDataDelegate
implements IExecutionData {
    private IExecutionData delegate;

    public ExecutionDataDelegate(long id, String name, int probeCount, FileChannel channel) {
        if (channel != null && ExecutionDataDelegate.canMapData(name)) {
            try {
                this.delegate = new MappedExecutionData(id, name, probeCount, channel);
            }
            catch (IOException e) {
                this.delegate = new ExecutionData(id, name, probeCount);
            }
        } else {
            this.delegate = new ExecutionData(id, name, probeCount);
        }
    }

    public synchronized void convert(FileChannel channel) throws IOException {
        if (!(this.delegate instanceof MappedExecutionData) && ExecutionDataDelegate.canMapData(this.getName())) {
            MappedExecutionData newDelegate = new MappedExecutionData(this.getId(), this.getName(), this.getProbeCount(), channel);
            newDelegate.merge(this.delegate);
            this.delegate = newDelegate;
        }
    }

    private static boolean canMapData(String name) {
        return !name.startsWith("android/app/") && !name.startsWith("android/os/") && !name.startsWith("com/android/internal/util/") && !name.startsWith("java/");
    }

    @Override
    public long getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public int getProbeCount() {
        return this.delegate.getProbeCount();
    }

    @Override
    public boolean[] getProbesCopy() {
        return this.delegate.getProbesCopy();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public boolean hasHits() {
        return this.delegate.hasHits();
    }

    @Override
    public void merge(IExecutionData other) {
        this.delegate.merge(other);
    }

    @Override
    public void merge(IExecutionData other, boolean flag) {
        this.delegate.merge(other, flag);
    }

    @Override
    public void assertCompatibility(long id, String name, int probeCount) throws IllegalStateException {
        this.delegate.assertCompatibility(id, name, probeCount);
    }

    @Override
    public boolean getProbe(int index) {
        return this.delegate.getProbe(index);
    }

    @Override
    public void setProbe(int index) {
        this.delegate.setProbe(index);
    }
}

