/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.IExecutionDataVisitor;

public final class ExecutionDataStore
implements IExecutionDataVisitor {
    private final Map<Long, IExecutionData> entries = new HashMap<Long, IExecutionData>();
    private final Set<String> names = new HashSet<String>();

    public void put(IExecutionData data) throws IllegalStateException {
        Long id = data.getId();
        IExecutionData entry = this.entries.get(id);
        if (entry == null) {
            this.entries.put(id, data);
            this.names.add(data.getName());
        } else {
            entry.merge(data);
        }
    }

    public void subtract(IExecutionData data) throws IllegalStateException {
        Long id = data.getId();
        IExecutionData entry = this.entries.get(id);
        if (entry != null) {
            entry.merge(data, false);
        }
    }

    public void subtract(ExecutionDataStore store) {
        for (IExecutionData data : store.getContents()) {
            this.subtract(data);
        }
    }

    public IExecutionData get(long id) {
        return this.entries.get(id);
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public IExecutionData get(Long id, String name, int probecount) {
        IExecutionData entry = this.entries.get(id);
        if (entry == null) {
            entry = new ExecutionData((long)id, name, probecount);
            this.entries.put(id, entry);
            this.names.add(name);
        } else {
            entry.assertCompatibility(id, name, probecount);
        }
        return entry;
    }

    public void reset() {
        for (IExecutionData executionData : this.entries.values()) {
            executionData.reset();
        }
    }

    public Collection<IExecutionData> getContents() {
        return new ArrayList<IExecutionData>(this.entries.values());
    }

    public void accept(IExecutionDataVisitor visitor) {
        for (IExecutionData data : this.getContents()) {
            visitor.visitClassExecution(data);
        }
    }

    @Override
    public void visitClassExecution(IExecutionData data) {
        this.put(data);
    }
}

