/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.jacoco.core.data.IExecutionData;

public final class MappedExecutionData
implements IExecutionData {
    private final long id;
    private final String name;
    private final int probeCount;
    private MappedByteBuffer probeBuffer;

    public MappedExecutionData(long id, String name, int probeCount, FileChannel channel) throws IOException {
        this.id = id;
        this.name = name;
        this.probeCount = probeCount;
        this.createMemoryMappedProbeArray(id, name, probeCount, channel);
    }

    public MappedExecutionData(long id, String name, boolean[] probes, FileChannel channel) throws IOException {
        this.id = id;
        this.name = name;
        this.probeCount = probes.length;
        this.createMemoryMappedProbeArray(id, name, probes.length, channel);
        for (int i = 0; i < probes.length; ++i) {
            if (!probes[i]) continue;
            this.setProbe(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMemoryMappedProbeArray(long id, String name, int probeCount, FileChannel channel) throws IOException {
        FileChannel fileChannel = channel;
        synchronized (fileChannel) {
            int byteCount = (probeCount + 7) / 8;
            ByteBuffer execDataBuffer = ByteBuffer.allocate(11);
            execDataBuffer.put((byte)17);
            execDataBuffer.putLong(id);
            execDataBuffer.putShort((short)name.length());
            execDataBuffer.flip();
            channel.write(execDataBuffer);
            channel.write(ByteBuffer.wrap(name.getBytes(Charset.forName("UTF-8"))));
            channel.write(this.toVarIntByteBuffer(probeCount));
            this.probeBuffer = channel.map(FileChannel.MapMode.READ_WRITE, channel.position(), byteCount);
            channel.position(channel.position() + (long)byteCount);
        }
    }

    private ByteBuffer toVarIntByteBuffer(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        if (value == 0) {
            buffer.put((byte)0);
        } else {
            while (value > 0) {
                if ((value & 0xFFFFFF80) == 0) {
                    buffer.put((byte)value);
                } else {
                    buffer.put((byte)(0x80 | value & 0x7F));
                }
                value >>>= 7;
            }
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getProbeCount() {
        return this.probeCount;
    }

    @Override
    public boolean[] getProbesCopy() {
        int bytes = (this.probeCount + 7) / 8;
        boolean[] probes = new boolean[this.probeCount];
        for (int index = 0; index < this.probeCount; index += 8) {
            byte byteProbe = this.probeBuffer.get(index / 8);
            for (int bit = 0; bit < 8 && index + bit < this.probeCount; ++bit) {
                probes[index + bit] = (byteProbe & 1) > 0;
                byteProbe = (byte)(byteProbe >>> 1);
            }
        }
        return probes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        int bytes = (this.probeCount + 7) / 8;
        MappedByteBuffer mappedByteBuffer = this.probeBuffer;
        synchronized (mappedByteBuffer) {
            for (int i = 0; i < bytes; ++i) {
                this.probeBuffer.put(i, (byte)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasHits() {
        int bytes = (this.probeCount + 7) / 8;
        MappedByteBuffer mappedByteBuffer = this.probeBuffer;
        synchronized (mappedByteBuffer) {
            for (int i = 0; i < bytes; ++i) {
                if (this.probeBuffer.get(i) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void merge(IExecutionData other) {
        this.merge(other, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(IExecutionData other, boolean flag) {
        MappedByteBuffer mappedByteBuffer = this.probeBuffer;
        synchronized (mappedByteBuffer) {
            for (int i = 0; i < this.probeCount; ++i) {
                if (!other.getProbe(i)) continue;
                this.setProbe(i);
            }
        }
    }

    @Override
    public void assertCompatibility(long id, String name, int probeCount) throws IllegalStateException {
        if (this.id != id) {
            throw new IllegalStateException(String.format("Different ids (%016x and %016x).", this.id, id));
        }
        if (!this.name.equals(name)) {
            throw new IllegalStateException(String.format("Different class names %s and %s for id %016x.", this.name, name, id));
        }
        if (this.probeCount != probeCount) {
            throw new IllegalStateException(String.format("Incompatible execution data for class %s with id %016x.", name, id));
        }
    }

    @Override
    public boolean getProbe(int index) {
        int offset = index / 8;
        int bit = 1 << index % 8;
        return (this.probeBuffer.get(offset) & bit) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProbe(int index) {
        int offset = index / 8;
        int bit = 1 << index % 8;
        byte currentValue = this.probeBuffer.get(offset);
        if ((currentValue & bit) == 0) {
            MappedByteBuffer mappedByteBuffer = this.probeBuffer;
            synchronized (mappedByteBuffer) {
                this.probeBuffer.put(offset, (byte)(this.probeBuffer.get(offset) | bit));
            }
        }
    }
}

