/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.SessionInfoStore;

public class ExecFileLoader {
    private final SessionInfoStore sessionInfos = new SessionInfoStore();
    private final ExecutionDataStore executionData = new ExecutionDataStore();

    public void load(InputStream stream) throws IOException {
        ExecutionDataReader reader = new ExecutionDataReader(new BufferedInputStream(stream));
        reader.setExecutionDataVisitor(this.executionData);
        reader.setSessionInfoVisitor(this.sessionInfos);
        reader.read();
    }

    public void load(File file2) throws IOException {
        try (FileInputStream stream = new FileInputStream(file2);){
            this.load(stream);
        }
    }

    public void save(OutputStream stream) throws IOException {
        ExecutionDataWriter dataWriter = new ExecutionDataWriter(stream);
        this.sessionInfos.accept(dataWriter);
        this.executionData.accept(dataWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file2, boolean append) throws IOException {
        File folder = file2.getParentFile();
        if (folder != null) {
            folder.mkdirs();
        }
        FileOutputStream fileStream = new FileOutputStream(file2, append);
        fileStream.getChannel().lock();
        try (BufferedOutputStream bufferedStream = new BufferedOutputStream(fileStream);){
            this.save(bufferedStream);
        }
    }

    public SessionInfoStore getSessionInfoStore() {
        return this.sessionInfos;
    }

    public ExecutionDataStore getExecutionDataStore() {
        return this.executionData;
    }
}

