/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.JavaNames;
import org.jacoco.report.csv.CSVGroupHandler;
import org.jacoco.report.csv.ClassRowWriter;
import org.jacoco.report.csv.DelimitedWriter;

public class CSVFormatter {
    private ILanguageNames languageNames = new JavaNames();
    private String outputEncoding = "UTF-8";

    public void setLanguageNames(ILanguageNames languageNames) {
        this.languageNames = languageNames;
    }

    public ILanguageNames getLanguageNames() {
        return this.languageNames;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public IReportVisitor createVisitor(OutputStream output) throws IOException {
        final DelimitedWriter writer = new DelimitedWriter(new OutputStreamWriter(output, this.outputEncoding));
        final ClassRowWriter rowWriter = new ClassRowWriter(writer, this.languageNames);
        class Visitor
        extends CSVGroupHandler
        implements IReportVisitor {
            Visitor() {
                super(classRowWriter);
            }

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<IExecutionData> executionData) throws IOException {
            }

            @Override
            public void visitEnd() throws IOException {
                writer.close();
            }
        }
        return new Visitor();
    }
}

