/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import java.io.Writer;

class DelimitedWriter {
    private static final String QUOTE = "\"";
    private static final String ESCAPED_QUOTE = "\"\"";
    private static final char DEFAULT_DELIMITER = ',';
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final char delimiter;
    private final Writer delegate;
    private int fieldPosition = 0;

    public DelimitedWriter(Writer delegate2) {
        this(delegate2, ',');
    }

    public DelimitedWriter(Writer delegate2, char delimiter) {
        this.delegate = delegate2;
        this.delimiter = delimiter;
    }

    public void write(String ... fields) throws IOException {
        for (String field : fields) {
            this.write(field);
        }
    }

    public void write(String field) throws IOException {
        if (this.fieldPosition != 0) {
            this.delegate.write(this.delimiter);
        }
        this.delegate.write(this.escape(field));
        ++this.fieldPosition;
    }

    public void write(int value) throws IOException {
        this.write(Integer.toString(value));
    }

    public void write(int ... values2) throws IOException {
        for (int value : values2) {
            this.write(Integer.toString(value));
        }
    }

    public void nextLine() throws IOException {
        this.delegate.write(NEW_LINE);
        this.fieldPosition = 0;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private String escape(String value) {
        String escapedValue = value;
        if (value.indexOf(QUOTE) != -1 || value.indexOf(this.delimiter) != -1) {
            escapedValue = value.replace(QUOTE, ESCAPED_QUOTE);
            escapedValue = QUOTE + escapedValue + QUOTE;
        }
        return escapedValue;
    }
}

