/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.html;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.JavaNames;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLGroupVisitor;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.ILinkable;
import org.jacoco.report.internal.html.index.ElementIndex;
import org.jacoco.report.internal.html.index.IIndexUpdate;
import org.jacoco.report.internal.html.page.BundlePage;
import org.jacoco.report.internal.html.page.ReportPage;
import org.jacoco.report.internal.html.page.SessionsPage;
import org.jacoco.report.internal.html.resources.Resources;
import org.jacoco.report.internal.html.table.BarColumn;
import org.jacoco.report.internal.html.table.CounterColumn;
import org.jacoco.report.internal.html.table.LabelColumn;
import org.jacoco.report.internal.html.table.PercentageColumn;
import org.jacoco.report.internal.html.table.Table;

public class HTMLFormatter
implements IHTMLReportContext {
    private ILanguageNames languageNames = new JavaNames();
    private Locale locale = Locale.getDefault();
    private String footerText = "";
    private String outputEncoding = "UTF-8";
    private Resources resources;
    private ElementIndex index;
    private SessionsPage sessionsPage;
    private Table table;

    public void setLanguageNames(ILanguageNames languageNames) {
        this.languageNames = languageNames;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public ILanguageNames getLanguageNames() {
        return this.languageNames;
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public Table getTable() {
        if (this.table == null) {
            this.table = this.createTable();
        }
        return this.table;
    }

    private Table createTable() {
        Table t = new Table();
        t.add("Element", null, new LabelColumn(), false);
        t.add("Missed Instructions", "bar", new BarColumn(ICoverageNode.CounterEntity.INSTRUCTION, this.locale), true);
        t.add("Cov.", "ctr2", new PercentageColumn(ICoverageNode.CounterEntity.INSTRUCTION, this.locale), false);
        t.add("Missed Branches", "bar", new BarColumn(ICoverageNode.CounterEntity.BRANCH, this.locale), false);
        t.add("Cov.", "ctr2", new PercentageColumn(ICoverageNode.CounterEntity.BRANCH, this.locale), false);
        this.addMissedTotalColumns(t, "Cxty", ICoverageNode.CounterEntity.COMPLEXITY);
        this.addMissedTotalColumns(t, "Lines", ICoverageNode.CounterEntity.LINE);
        this.addMissedTotalColumns(t, "Methods", ICoverageNode.CounterEntity.METHOD);
        this.addMissedTotalColumns(t, "Classes", ICoverageNode.CounterEntity.CLASS);
        return t;
    }

    private void addMissedTotalColumns(Table table, String label, ICoverageNode.CounterEntity entity) {
        table.add("Missed", "ctr1", CounterColumn.newMissed(entity, this.locale), false);
        table.add(label, "ctr2", CounterColumn.newTotal(entity, this.locale), false);
    }

    @Override
    public String getFooterText() {
        return this.footerText;
    }

    @Override
    public ILinkable getSessionsPage() {
        return this.sessionsPage;
    }

    @Override
    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Override
    public IIndexUpdate getIndexUpdate() {
        return this.index;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public IReportVisitor createVisitor(final IMultiReportOutput output) throws IOException {
        final ReportOutputFolder root = new ReportOutputFolder(output);
        this.resources = new Resources(root);
        this.resources.copyResources();
        this.index = new ElementIndex(root);
        return new IReportVisitor(){
            private List<SessionInfo> sessionInfos;
            private Collection<IExecutionData> executionData;
            private HTMLGroupVisitor groupHandler;

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<IExecutionData> executionData) throws IOException {
                this.sessionInfos = sessionInfos;
                this.executionData = executionData;
            }

            @Override
            public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
                BundlePage page = new BundlePage(bundle, null, locator, root, HTMLFormatter.this);
                this.createSessionsPage(page);
                page.render();
            }

            @Override
            public IReportGroupVisitor visitGroup(String name) throws IOException {
                this.groupHandler = new HTMLGroupVisitor(null, root, HTMLFormatter.this, name);
                this.createSessionsPage(this.groupHandler.getPage());
                return this.groupHandler;
            }

            private void createSessionsPage(ReportPage rootpage) {
                HTMLFormatter.this.sessionsPage = new SessionsPage(this.sessionInfos, this.executionData, HTMLFormatter.this.index, rootpage, root, HTMLFormatter.this);
            }

            @Override
            public void visitEnd() throws IOException {
                if (this.groupHandler != null) {
                    this.groupHandler.visitEnd();
                }
                HTMLFormatter.this.sessionsPage.render();
                output.close();
            }
        };
    }
}

