/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.page;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jacoco.core.data.IExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.index.ElementIndex;
import org.jacoco.report.internal.html.page.ReportPage;

public class SessionsPage
extends ReportPage {
    private static final String MSG_SESSIONS = "This coverage report is based on execution data from the following sessions:";
    private static final String MSG_NO_SESSIONS = "No session information available.";
    private static final String MSG_EXECDATA = "Execution data for the following classes is considered in this report:";
    private static final String MSG_NO_EXECDATA = "No execution data available.";
    private final List<SessionInfo> sessionInfos;
    private final DateFormat dateFormat;
    private final List<IExecutionData> executionData;
    private final ElementIndex index;

    public SessionsPage(List<SessionInfo> sessionInfos, Collection<IExecutionData> executionData, ElementIndex index, ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context) {
        super(parent, folder, context);
        this.sessionInfos = sessionInfos;
        this.executionData = new ArrayList<IExecutionData>(executionData);
        this.index = index;
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2, context.getLocale());
        final ILanguageNames names = context.getLanguageNames();
        Collections.sort(this.executionData, new Comparator<IExecutionData>(){

            @Override
            public int compare(IExecutionData e1, IExecutionData e2) {
                return names.getQualifiedClassName(e1.getName()).compareTo(names.getQualifiedClassName(e2.getName()));
            }
        });
    }

    @Override
    protected void content(HTMLElement body) throws IOException {
        if (this.sessionInfos.isEmpty()) {
            body.p().text(MSG_NO_SESSIONS);
        } else {
            body.p().text(MSG_SESSIONS);
            this.sessionTable(body);
        }
        if (this.executionData.isEmpty()) {
            body.p().text(MSG_NO_EXECDATA);
        } else {
            body.p().text(MSG_EXECDATA);
            this.executionDataTable(body);
        }
    }

    private void sessionTable(HTMLElement body) throws IOException {
        HTMLElement table = body.table("coverage");
        HTMLElement tr = table.thead().tr();
        tr.td().text("Session");
        tr.td().text("Start Time");
        tr.td().text("Dump Time");
        HTMLElement tbody = table.tbody();
        for (SessionInfo i : this.sessionInfos) {
            HTMLElement tr2 = tbody.tr();
            tr2.td().span("el_session").text(i.getId());
            tr2.td().text(this.dateFormat.format(new Date(i.getStartTimeStamp())));
            tr2.td().text(this.dateFormat.format(new Date(i.getDumpTimeStamp())));
        }
    }

    private void executionDataTable(HTMLElement body) throws IOException {
        HTMLElement table = body.table("coverage");
        HTMLElement tr = table.thead().tr();
        tr.td().text("Class");
        tr.td().text("Id");
        HTMLElement tbody = table.tbody();
        ILanguageNames names = this.context.getLanguageNames();
        for (IExecutionData e : this.executionData) {
            HTMLElement tr2 = tbody.tr();
            String link = this.index.getLinkToClass(e.getId());
            String qualifiedName = names.getQualifiedClassName(e.getName());
            if (link == null) {
                tr2.td().span("el_class").text(qualifiedName);
            } else {
                tr2.td().a(link, "el_class").text(qualifiedName);
            }
            String id = String.format("%016x", e.getId());
            tr2.td().code().text(id);
        }
    }

    @Override
    protected String getFileName() {
        return "jacoco-sessions.html";
    }

    @Override
    public String getLinkStyle() {
        return "el_session";
    }

    @Override
    public String getLinkLabel() {
        return "Sessions";
    }
}

