/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public abstract class ComparisonCriteria {
    private static final Object END_OF_ARRAY_SENTINEL = ComparisonCriteria.objectWithToString("end of array");

    public void arrayEquals(String message2, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        this.arrayEquals(message2, expecteds, actuals, true);
    }

    private void arrayEquals(String message2, Object expecteds, Object actuals, boolean outer) throws ArrayComparisonFailure {
        int expectedsLength;
        int actualsLength;
        String exceptionMessage;
        if (expecteds == actuals || Arrays.deepEquals(new Object[]{expecteds}, new Object[]{actuals})) {
            return;
        }
        String header = message2 == null ? "" : message2 + ": ";
        String string = exceptionMessage = outer ? header : "";
        if (expecteds == null) {
            Assert.fail(exceptionMessage + "expected array was null");
        }
        if (actuals == null) {
            Assert.fail(exceptionMessage + "actual array was null");
        }
        if ((actualsLength = Array.getLength(actuals)) != (expectedsLength = Array.getLength(expecteds))) {
            header = header + "array lengths differed, expected.length=" + expectedsLength + " actual.length=" + actualsLength + "; ";
        }
        int prefixLength = Math.min(actualsLength, expectedsLength);
        for (int i = 0; i < prefixLength; ++i) {
            Object expected = Array.get(expecteds, i);
            Object actual = Array.get(actuals, i);
            if (this.isArray(expected) && this.isArray(actual)) {
                try {
                    this.arrayEquals(message2, expected, actual, false);
                    continue;
                }
                catch (ArrayComparisonFailure e) {
                    e.addDimension(i);
                    throw e;
                }
                catch (AssertionError e) {
                    throw new ArrayComparisonFailure(header, e, i);
                }
            }
            try {
                this.assertElementsEqual(expected, actual);
                continue;
            }
            catch (AssertionError e) {
                throw new ArrayComparisonFailure(header, e, i);
            }
        }
        if (actualsLength != expectedsLength) {
            Object expected = this.getToStringableArrayElement(expecteds, expectedsLength, prefixLength);
            Object actual = this.getToStringableArrayElement(actuals, actualsLength, prefixLength);
            try {
                Assert.assertEquals(expected, actual);
            }
            catch (AssertionError e) {
                throw new ArrayComparisonFailure(header, e, prefixLength);
            }
        }
    }

    private Object getToStringableArrayElement(Object array, int length, int index) {
        if (index < length) {
            Object element = Array.get(array, index);
            if (this.isArray(element)) {
                return ComparisonCriteria.objectWithToString(this.componentTypeName(element.getClass()) + "[" + Array.getLength(element) + "]");
            }
            return element;
        }
        return END_OF_ARRAY_SENTINEL;
    }

    private static Object objectWithToString(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private String componentTypeName(Class<?> arrayClass) {
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType.isArray()) {
            return this.componentTypeName(componentType) + "[]";
        }
        return componentType.getName();
    }

    private boolean isArray(Object expected) {
        return expected != null && expected.getClass().isArray();
    }

    protected abstract void assertElementsEqual(Object var1, Object var2);
}

