/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.junit.internal.Classes;
import org.junit.internal.management.RuntimeMXBean;

final class ReflectiveRuntimeMXBean
implements RuntimeMXBean {
    private final Object runtimeMxBean;

    ReflectiveRuntimeMXBean(Object runtimeMxBean) {
        this.runtimeMxBean = runtimeMxBean;
    }

    @Override
    public List<String> getInputArguments() {
        if (Holder.getInputArgumentsMethod != null) {
            try {
                return (List)Holder.getInputArgumentsMethod.invoke(this.runtimeMxBean, new Object[0]);
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static final class Holder {
        private static final Method getInputArgumentsMethod;

        private Holder() {
        }

        static {
            Method inputArguments = null;
            try {
                Class<?> threadMXBeanClass = Classes.getClass("java.lang.management.RuntimeMXBean");
                inputArguments = threadMXBeanClass.getMethod("getInputArguments", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            getInputArgumentsMethod = inputArguments;
        }
    }
}

