/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.internal.Classes;
import org.junit.internal.management.ThreadMXBean;

final class ReflectiveThreadMXBean
implements ThreadMXBean {
    private final Object threadMxBean;

    ReflectiveThreadMXBean(Object threadMxBean) {
        this.threadMxBean = threadMxBean;
    }

    @Override
    public long getThreadCpuTime(long id) {
        if (Holder.getThreadCpuTimeMethod != null) {
            Exception error = null;
            try {
                return (Long)Holder.getThreadCpuTimeMethod.invoke(this.threadMxBean, id);
            }
            catch (ClassCastException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
            catch (IllegalArgumentException e) {
                error = e;
            }
            catch (InvocationTargetException e) {
                error = e;
            }
            throw new UnsupportedOperationException("Unable to access ThreadMXBean", error);
        }
        throw new UnsupportedOperationException("Unable to access ThreadMXBean");
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        if (Holder.isThreadCpuTimeSupportedMethod != null) {
            try {
                return (Boolean)Holder.isThreadCpuTimeSupportedMethod.invoke(this.threadMxBean, new Object[0]);
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    private static final class Holder {
        static final Method getThreadCpuTimeMethod;
        static final Method isThreadCpuTimeSupportedMethod;
        private static final String FAILURE_MESSAGE = "Unable to access ThreadMXBean";

        private Holder() {
        }

        static {
            Method threadCpuTime = null;
            Method threadCpuTimeSupported = null;
            try {
                Class<?> threadMXBeanClass = Classes.getClass("java.lang.management.ThreadMXBean");
                threadCpuTime = threadMXBeanClass.getMethod("getThreadCpuTime", Long.TYPE);
                threadCpuTimeSupported = threadMXBeanClass.getMethod("isThreadCpuTimeSupported", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            getThreadCpuTimeMethod = threadCpuTime;
            isThreadCpuTimeSupportedMethod = threadCpuTimeSupported;
        }
    }
}

