/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.Statement;

public class ExpectException
extends Statement {
    private final Statement next;
    private final Class<? extends Throwable> expected;

    public ExpectException(Statement next, Class<? extends Throwable> expected) {
        this.next = next;
        this.expected = expected;
    }

    @Override
    public void evaluate() throws Exception {
        boolean complete;
        block5: {
            complete = false;
            try {
                this.next.evaluate();
                complete = true;
            }
            catch (AssumptionViolatedException e) {
                if (!this.expected.isAssignableFrom(e.getClass())) {
                    throw e;
                }
            }
            catch (Throwable e) {
                if (this.expected.isAssignableFrom(e.getClass())) break block5;
                String message2 = "Unexpected exception, expected<" + this.expected.getName() + "> but was<" + e.getClass().getName() + ">";
                throw new Exception(message2, e);
            }
        }
        if (complete) {
            throw new AssertionError((Object)("Expected exception: " + this.expected.getName()));
        }
    }
}

