/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.IItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.parser.NoopParser;
import com.android.loganalysis.util.RegexTrie;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSectionParser
implements IParser {
    private RegexTrie<IParser> mSectionTrie = new RegexTrie();
    private IParser mCurrentParser = new NoopParser();
    private List<String> mParseBlock = new LinkedList<String>();
    private Map<IParser, IItem> mSections = new HashMap<IParser, IItem>();

    protected void addSectionParser(IParser parser, String pattern) {
        if (parser == null) {
            throw new NullPointerException("Parser is null");
        }
        if (pattern == null) {
            throw new NullPointerException("Pattern is null");
        }
        this.mSectionTrie.put(parser, pattern);
    }

    protected void parseLine(String line) {
        IParser nextParser = this.mSectionTrie.retrieve(line);
        if (nextParser == null) {
            if (this.mCurrentParser != null) {
                this.mParseBlock.add(line);
            }
        } else {
            this.runCurrentParser();
            this.mCurrentParser = nextParser;
        }
    }

    protected void commit() {
        this.runCurrentParser();
    }

    protected IItem getSection(IParser parser) {
        return this.mSections.get(parser);
    }

    protected void setParser(IParser parser) {
        this.mCurrentParser = parser;
    }

    protected void onSwitchParser() {
    }

    private void runCurrentParser() {
        IItem item;
        if (this.mCurrentParser != null && (item = this.mCurrentParser.parse(this.mParseBlock)) != null && !(this.mCurrentParser instanceof NoopParser)) {
            this.mSections.put(this.mCurrentParser, item);
        }
        this.mParseBlock.clear();
        this.onSwitchParser();
    }
}

