/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.DumpsysBatteryStatsItem;
import com.android.loganalysis.item.DumpsysItem;
import com.android.loganalysis.item.DumpsysPackageStatsItem;
import com.android.loganalysis.item.DumpsysProcStatsItem;
import com.android.loganalysis.item.DumpsysWifiStatsItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.parser.DumpsysBatteryStatsParser;
import com.android.loganalysis.parser.DumpsysPackageStatsParser;
import com.android.loganalysis.parser.DumpsysProcStatsParser;
import com.android.loganalysis.parser.DumpsysWifiStatsParser;
import com.android.loganalysis.parser.NoopParser;
import java.util.List;

public class DumpsysParser
extends AbstractSectionParser {
    private static final String BATTERY_STATS_SECTION_REGEX = "^DUMP OF SERVICE batterystats:$";
    private static final String PACKAGE_SECTION_REGEX = "^DUMP OF SERVICE package:";
    private static final String PROC_STATS_SECTION_REGEX = "^DUMP OF SERVICE procstats:";
    private static final String WIFI_SECTION_REGEX = "^DUMP OF SERVICE wifi:";
    private static final String NOOP_SECTION_REGEX = "DUMP OF SERVICE .*";
    private DumpsysBatteryStatsParser mBatteryStatsParser = new DumpsysBatteryStatsParser();
    private DumpsysPackageStatsParser mPackageStatsParser = new DumpsysPackageStatsParser();
    private DumpsysProcStatsParser mProcStatsParser = new DumpsysProcStatsParser();
    private DumpsysWifiStatsParser mWifiStatsParser = new DumpsysWifiStatsParser();
    private DumpsysItem mDumpsys = null;

    @Override
    public DumpsysItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            if (this.mDumpsys == null && !"".equals(line.trim())) {
                this.mDumpsys = new DumpsysItem();
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mDumpsys;
    }

    protected void setup() {
        this.addSectionParser(this.mBatteryStatsParser, BATTERY_STATS_SECTION_REGEX);
        this.addSectionParser(this.mPackageStatsParser, PACKAGE_SECTION_REGEX);
        this.addSectionParser(this.mProcStatsParser, PROC_STATS_SECTION_REGEX);
        this.addSectionParser(this.mWifiStatsParser, WIFI_SECTION_REGEX);
        this.addSectionParser(new NoopParser(), NOOP_SECTION_REGEX);
    }

    @Override
    protected void commit() {
        super.commit();
        if (this.mDumpsys == null) {
            this.mDumpsys = new DumpsysItem();
        }
        if (this.mDumpsys != null) {
            this.mDumpsys.setBatteryInfo((DumpsysBatteryStatsItem)this.getSection(this.mBatteryStatsParser));
            this.mDumpsys.setPackageStats((DumpsysPackageStatsItem)this.getSection(this.mPackageStatsParser));
            this.mDumpsys.setProcStats((DumpsysProcStatsItem)this.getSection(this.mProcStatsParser));
            this.mDumpsys.setWifiStats((DumpsysWifiStatsItem)this.getSection(this.mWifiStatsParser));
        }
    }
}

