/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.LocationDumpsItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationServiceParser
implements IParser {
    private static final Pattern LOCATION_PAT = Pattern.compile("^\\s*Interval effective/min/max (\\d+)/(\\d+)/(\\d+)\\[s\\] Duration: (\\d+)\\[minutes\\]\\s*\\[([\\w.]+), (\\w+)(,.*)?\\] Num requests: \\d+ Active: \\w*");
    private LocationDumpsItem mItem = new LocationDumpsItem();

    @Override
    public LocationDumpsItem parse(List<String> lines) {
        Matcher m = null;
        for (String line : lines) {
            m = LOCATION_PAT.matcher(line);
            if (!m.matches()) continue;
            this.mItem.addLocationClient(m.group(5), NumberFormattingUtil.parseIntOrZero(m.group(1)), NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(3)), m.group(6), NumberFormattingUtil.parseIntOrZero(m.group(4)));
        }
        return this.mItem;
    }

    LocationDumpsItem getItem() {
        return this.mItem;
    }
}

