/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.SystemPropsItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.ArrayUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemPropsParser
implements IParser {
    private static final Pattern PROP_LINE = Pattern.compile("^\\[(.*)\\]: \\[(.*)\\]$");

    @Override
    public SystemPropsItem parse(List<String> lines) {
        String text = ArrayUtil.join("\n", lines).trim();
        if ("".equals(text)) {
            return null;
        }
        SystemPropsItem item = new SystemPropsItem();
        item.setText(text);
        for (String line : lines) {
            Matcher m = PROP_LINE.matcher(line);
            if (!m.matches()) continue;
            item.put(m.group(1), m.group(2));
        }
        return item;
    }
}

