/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.ResultUploader;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IDisableable;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@OptionClass(alias="result-reporter")
public class CertificationReportCreator
implements ILogSaverListener,
ITestSummaryListener,
IConfigurationReceiver,
IDisableable {
    public static final String HTLM_REPORT_NAME = "test_result.html";
    public static final String REPORT_XSL_FILE_NAME = "compatibility_result.xsl";
    public static final String FAILURE_REPORT_NAME = "test_result_failures_suite.html";
    public static final String FAILURE_XSL_FILE_NAME = "compatibility_failures.xsl";
    public static final String INCLUDE_HTML_IN_ZIP = "html-in-zip";
    @Option(name="disable", description="Whether or not to disable this reporter.")
    private boolean mDisable = false;
    @Option(name="html-in-zip", description="Whether failure summary report is included in the zip fie.")
    private boolean mIncludeHtml = false;
    @Option(name="result-server", description="Server to publish test results.")
    private String mResultServer;
    @Option(name="disable-result-posting", description="Disable result posting into report server.")
    private boolean mDisableResultPosting = false;
    @Option(name="use-log-saver", description="Also saves generated result with log saver")
    private boolean mUseLogSaver = false;
    private ILogSaver mLogSaver;
    private IConfiguration mConfiguration;
    private CompatibilityBuildHelper mBuildHelper;
    private String mReferenceUrl;
    private File mReportFile;

    public void setLogSaver(ILogSaver saver) {
        this.mLogSaver = saver;
    }

    public void putSummary(List<TestSummary> summaries) {
        for (TestSummary summary : summaries) {
            if (this.mReferenceUrl != null || summary.getSummary().getString() == null) continue;
            this.mReferenceUrl = summary.getSummary().getString();
        }
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    private IConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public void invocationStarted(IInvocationContext context) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)context.getBuildInfos().get(0));
        }
    }

    public void setReportFile(File reportFile) {
        this.mReportFile = reportFile;
    }

    public void invocationEnded(long elapsedTime) {
        File resultDir;
        if (this.mReportFile == null) {
            LogUtil.CLog.w((String)"Did not receive the report file to be packaged");
            return;
        }
        try {
            resultDir = this.mBuildHelper.getResultDir();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        File report = null;
        File failureReport = null;
        if (this.mIncludeHtml) {
            report = this.createReport(this.mReportFile);
            failureReport = this.createFailureReport(this.mReportFile);
        }
        File zippedResults = CertificationReportCreator.zipResults(resultDir);
        if (!this.mIncludeHtml) {
            report = this.createReport(this.mReportFile);
            failureReport = this.createFailureReport(this.mReportFile);
        }
        if (report != null) {
            LogUtil.CLog.i((String)"Viewable report: %s", (Object[])new Object[]{report.getAbsolutePath()});
        }
        try {
            if (failureReport.exists()) {
                LogUtil.CLog.i((String)"Test Result: %s", (Object[])new Object[]{failureReport.getCanonicalPath()});
            } else {
                LogUtil.CLog.i((String)"Test Result: %s", (Object[])new Object[]{this.mReportFile.getCanonicalPath()});
            }
            this.saveLog(this.mReportFile, zippedResults);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Error when handling the post processing of results file:");
            LogUtil.CLog.e((Throwable)e);
        }
        this.uploadResult(this.mReportFile);
    }

    private static File zipResults(File resultsDir) {
        File zipResultFile = null;
        try {
            zipResultFile = new File(resultsDir.getParent(), String.format("%s.zip", resultsDir.getName()));
            ZipUtil.createZip((File)resultsDir, (File)zipResultFile);
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)"Failed to create zip for %s", (Object[])new Object[]{resultsDir.getName()});
        }
        return zipResultFile;
    }

    private void uploadResult(File resultFile) {
        if (this.mResultServer != null && !this.mResultServer.trim().isEmpty() && !this.mDisableResultPosting) {
            ResultUploader uploader = new ResultUploader(this.mResultServer, this.mBuildHelper.getSuiteName());
            try {
                LogUtil.CLog.d((String)"Result Server: %d", (Object[])new Object[]{uploader.uploadResult(resultFile, this.mReferenceUrl)});
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"IOException while uploading result.");
                LogUtil.CLog.e((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File resultFile, File zippedResults) throws IOException {
        if (!this.mUseLogSaver) {
            return;
        }
        FileInputStream fis = null;
        LogFile logFile = null;
        try {
            fis = new FileInputStream(resultFile);
            logFile = this.mLogSaver.saveLogData("log-result", LogDataType.XML, (InputStream)fis);
            LogUtil.CLog.d((String)"Result XML URL: %s", (Object[])new Object[]{logFile.getUrl()});
            this.logReportFiles(this.getConfiguration(), resultFile, resultFile.getName(), LogDataType.XML);
        }
        catch (IOException ioe) {
            try {
                LogUtil.CLog.e((String)"error saving XML with log saver");
                LogUtil.CLog.e((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.close(fis);
                throw throwable;
            }
            StreamUtil.close((Closeable)fis);
        }
        StreamUtil.close((Closeable)fis);
        if (zippedResults != null) {
            FileInputStream zipResultStream = null;
            try {
                zipResultStream = new FileInputStream(zippedResults);
                logFile = this.mLogSaver.saveLogData("results", LogDataType.ZIP, (InputStream)zipResultStream);
                LogUtil.CLog.d((String)"Result zip URL: %s", (Object[])new Object[]{logFile.getUrl()});
                this.logReportFiles(this.getConfiguration(), zippedResults, "results", LogDataType.ZIP);
            }
            catch (Throwable throwable) {
                StreamUtil.close(zipResultStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)zipResultStream);
        }
    }

    private File createReport(File inputXml) {
        File report = new File(inputXml.getParentFile(), HTLM_REPORT_NAME);
        try (FileInputStream xslStream = new FileInputStream(new File(inputXml.getParentFile(), REPORT_XSL_FILE_NAME));
             FileOutputStream outputStream = new FileOutputStream(report);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(inputXml), new StreamResult(outputStream));
        }
        catch (IOException | TransformerException ignored) {
            LogUtil.CLog.e((Throwable)ignored);
            FileUtil.deleteFile((File)report);
            return null;
        }
        return report;
    }

    private File createFailureReport(File inputXml) {
        File failureReport = new File(inputXml.getParentFile(), FAILURE_REPORT_NAME);
        try (InputStream xslStream = CertificationReportCreator.class.getResourceAsStream(String.format("/report/%s", FAILURE_XSL_FILE_NAME));
             FileOutputStream outputStream = new FileOutputStream(failureReport);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(inputXml), new StreamResult(outputStream));
        }
        catch (IOException | TransformerException ignored) {
            LogUtil.CLog.e((Throwable)ignored);
        }
        return failureReport;
    }

    private void logReportFiles(IConfiguration configuration, File resultFile, String dataName, LogDataType type) {
        if (configuration == null) {
            return;
        }
        ILogSaver saver = configuration.getLogSaver();
        List listeners = configuration.getTestInvocationListeners();
        try (FileInputStreamSource source = new FileInputStreamSource(resultFile);){
            LogFile loggedFile = null;
            try (InputStream stream = source.createInputStream();){
                loggedFile = saver.saveLogData(dataName, type, stream);
            }
            catch (IOException e) {
                LogUtil.CLog.e((Throwable)e);
            }
            for (ITestInvocationListener listener : listeners) {
                if (listener.equals(this)) continue;
                listener.testLog(dataName, type, (InputStreamSource)source);
                if (loggedFile == null || !(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(dataName, loggedFile);
            }
        }
    }

    public boolean isDisabled() {
        return this.mDisable;
    }
}

