/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="device-file-collector")
public class DeviceFileCollector
extends PreconditionPreparer {
    @Option(name="skip-device-info", shortName=100, description="Whether device info collection should be skipped")
    private boolean mSkipDeviceInfo = false;
    @Option(name="src-file", description="The file path to copy to the results dir")
    private String mSrcFile;
    @Option(name="dest-file", description="The destination file path under the result")
    private String mDestFile;
    @Option(name="property", description="run this test on device with this property value")
    private Map<String, String> mPropertyMap = new HashMap<String, String>();
    private File mResultFile;

    @Override
    public void run(TestInformation testInfo) {
        if (this.mSkipDeviceInfo) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (!this.matchProperties(device)) {
            return;
        }
        this.createResultDir(testInfo.getBuildInfo());
        if (this.mResultFile != null && !this.mResultFile.isDirectory() && this.mSrcFile != null && !this.mSrcFile.isEmpty()) {
            try {
                if (device.doesFileExist(this.mSrcFile)) {
                    device.pullFile(this.mSrcFile, this.mResultFile);
                } else {
                    LogUtil.CLog.w((String)String.format("File does not exist on device: \"%s\"", this.mSrcFile));
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Caught exception during pull.");
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    private void createResultDir(IBuildInfo buildInfo) {
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        try {
            File resultDir = buildHelper.getResultDir();
            if (this.mDestFile == null || this.mDestFile.isEmpty()) {
                this.mDestFile = Paths.get(this.mSrcFile, new String[0]).getFileName().toString();
            }
            this.mResultFile = Paths.get(resultDir.getAbsolutePath(), this.mDestFile).toFile();
            resultDir = this.mResultFile.getParentFile();
            resultDir.mkdirs();
            if (!resultDir.isDirectory()) {
                LogUtil.CLog.e((String)"%s is not a directory", (Object[])new Object[]{resultDir.getAbsolutePath()});
                return;
            }
        }
        catch (FileNotFoundException fnfe) {
            LogUtil.CLog.e((Throwable)fnfe);
        }
    }

    private boolean matchProperties(ITestDevice device) {
        for (Map.Entry<String, String> propEntry : this.mPropertyMap.entrySet()) {
            try {
                String actualValue = device.getProperty(propEntry.getKey());
                if (propEntry.getValue().equals(actualValue)) continue;
                LogUtil.CLog.i((String)"Skipping '%s' because property doesn't match. (key=%s, expected=%s, actual=%s)", (Object[])new Object[]{this.mSrcFile, propEntry.getKey(), propEntry.getValue(), actualValue});
                return false;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Caught exception during property check.");
                LogUtil.CLog.e((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

