/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.car.aaosbt;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IRemoteTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@OptionClass(alias="aaos-moped-test")
public class MopedRunner
implements IRemoteTest {
    @Option(name="test-artifact", description="test artifact")
    private File test_artifact = null;
    @Option(name="artifact", description="test artifact")
    private String artifact_str = null;
    @Option(name="unzip-build-timeout-min", description="unzip build timeout in minutes")
    private int unzip_build_timeout_min = 10;
    @Option(name="test-timeout-min", description="test timeout in minutes")
    private int test_timeout_min = 60;
    @Option(name="testcase", description="which moped test binary to run")
    private String test_case = null;
    private File mLocalDestFile;
    private File mLocalSrcFile;
    private String mArtifactLocation;

    private void unTarTestArtifact(TestInformation testInfo) throws TargetSetupError, TimeoutException, URISyntaxException {
        if (this.test_artifact != null && this.artifact_str == null) {
            this.artifact_str = this.test_artifact.toPath().toString();
        }
        String jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        File jarFile = new File(jarPath);
        this.mLocalSrcFile = new File(jarFile.getParent() + "/../testcases/" + this.artifact_str);
        this.mLocalDestFile = new File(testInfo.dependenciesFolder().toString());
        this.mArtifactLocation = this.mLocalDestFile.getPath() + "/" + this.mLocalSrcFile.getName().replaceAll(".tar.*gz", "/");
        Path localArtifactPath = Paths.get(this.mArtifactLocation, new String[0]);
        if (!Files.exists(localArtifactPath, new LinkOption[0])) {
            this.executeHostCommand(new String[]{"bash", "-c", "tar xf " + this.mLocalSrcFile.getPath() + " -C " + this.mLocalDestFile.getPath()}, this.unzip_build_timeout_min);
        }
    }

    private String getDevicesString(TestInformation testInfo) throws DeviceNotAvailableException {
        StringBuilder deviceString = new StringBuilder();
        int deviceNum = 0;
        for (ITestDevice device : testInfo.getDevices()) {
            if (deviceNum == 0) {
                deviceString.append(String.format(" --hu %s", device.getSerialNumber()));
            } else {
                deviceString.append(String.format(" --phone%s %s", String.valueOf(deviceNum), device.getSerialNumber()));
            }
            ++deviceNum;
        }
        deviceString.append(String.format(" --devicenum %s", String.valueOf(deviceNum)));
        return deviceString.toString();
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            this.unTarTestArtifact(testInfo);
            this.executeHostCommand(new String[]{"bash", "-c", "bash " + String.format("%s/run.sh %s --testcase %s", this.mArtifactLocation, this.getDevicesString(testInfo), this.test_case)}, this.test_timeout_min);
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"There are problems running tests! %s", (Object[])new Object[]{e});
        }
        catch (TimeoutException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"Test execution timeout! %s", (Object[])new Object[]{e});
        }
        catch (URISyntaxException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"Test artifact not found! %s", (Object[])new Object[]{e});
        }
    }

    private ArrayList<String> executeHostCommand(String[] command, int timeout) throws TargetSetupError, TimeoutException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            String line;
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"Output of running %s is:", (Object[])new Object[]{Arrays.toString(command)});
            Process p = Runtime.getRuntime().exec(command);
            if (!p.waitFor(timeout, TimeUnit.MINUTES)) {
                p.destroy();
                throw new TimeoutException();
            }
            InputStream is = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)line);
                ret.add(line);
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new TargetSetupError("Execution of command " + Arrays.toString(command) + " failed!");
            }
        }
        catch (IOException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"There are problems with IO! %s", (Object[])new Object[]{e});
        }
        catch (InterruptedException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.VERBOSE, (String)"User interruption!");
        }
        return ret;
    }
}

