/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.util.MonitoringUtils;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;

public class NetworkConnectivityChecker
implements ISystemStatusChecker {
    private boolean mIsFailed = false;

    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        if (!MonitoringUtils.checkDeviceConnectivity((ITestDevice)device)) {
            if (this.mIsFailed) {
                LogUtil.CLog.w((String)"NetworkConnectivityChecker is still failing on %s.", (Object[])new Object[]{device.getSerialNumber()});
                return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
            }
            this.mIsFailed = true;
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        }
        this.mIsFailed = false;
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }
}

