/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="settings-preparer")
public class SettingsPreparer
extends PreconditionPreparer {
    @Option(name="device-setting", description="The setting on the device to be checked")
    protected String mSettingName = null;
    @Option(name="setting-type", description="If the setting is 'secure', 'global', or 'system'")
    protected SettingType mSettingType = null;
    @Option(name="set-value", description="The value to be set for the setting")
    protected String mSetValue = null;
    @Option(name="expected-values", description="The set of expected values of the setting")
    protected List<String> mExpectedSettingValues = new ArrayList<String>();
    @Option(name="failure-message", description="The text printed for an unexpected value")
    protected String mFailureMessage = null;

    @Override
    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        String shellCmdPut;
        ITestDevice device = testInfo.getDevice();
        if (this.mSettingName == null) {
            throw new TargetSetupError("The \"device-setting\" option must be defined for the SettingsPreparer class", device.getDeviceDescriptor());
        }
        if (this.mSettingType == null) {
            throw new TargetSetupError("The \"setting-type\" option must be defined for the SettingsPreparer class", device.getDeviceDescriptor());
        }
        if (this.mSetValue == null && this.mExpectedSettingValues.isEmpty()) {
            throw new TargetSetupError("At least one of the options \"set-value\" and \"expected-values\" must be set", device.getDeviceDescriptor());
        }
        String testUser = testInfo.properties().get("RUN_TESTS_AS_USER");
        String userArg = " ";
        if (testUser != null && !testUser.isEmpty() && this.mSettingType != SettingType.GLOBAL) {
            userArg = String.format(" --user %s ", testUser);
        }
        String shellCmdGet = !this.mExpectedSettingValues.isEmpty() ? String.format("settings get %s%s%s", new Object[]{this.mSettingType, userArg, this.mSettingName}) : "";
        String string = shellCmdPut = this.mSetValue != null ? String.format("settings put %s%s%s %s", new Object[]{this.mSettingType, userArg, this.mSettingName, this.mSetValue}) : "";
        if (this.mSetValue != null && !this.mExpectedSettingValues.isEmpty()) {
            if (!this.mExpectedSettingValues.contains(this.mSetValue)) {
                throw new TargetSetupError(String.format("set-value for %s is %s, but value not found in expected-values: %s", this.mSettingName, this.mSetValue, this.mExpectedSettingValues.toString()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            String currentSettingValue = device.executeShellCommand(shellCmdGet).trim();
            if (!this.mExpectedSettingValues.contains(currentSettingValue)) {
                LogUtil.CLog.d((String)"Changing value for %s from %s to %s", (Object[])new Object[]{this.mSettingName, currentSettingValue, this.mSetValue});
                device.executeShellCommand(shellCmdPut);
            }
            return;
        }
        if (this.mSetValue != null) {
            LogUtil.CLog.d((String)"Setting %s to value %s", (Object[])new Object[]{this.mSettingName, this.mSetValue});
            device.executeShellCommand(shellCmdPut);
            return;
        }
        String currentSettingValue = device.executeShellCommand(shellCmdGet).trim();
        if (!this.mExpectedSettingValues.contains(currentSettingValue)) {
            if (this.mFailureMessage == null) {
                this.mFailureMessage = String.format("Device setting \"%s\" returned \"%s\", not found in %s", this.mSettingName, currentSettingValue, this.mExpectedSettingValues.toString());
            }
            throw new TargetSetupError(this.mFailureMessage, device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    public static enum SettingType {
        SECURE,
        GLOBAL,
        SYSTEM;

    }
}

