/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="wifi-check")
public class WifiCheck
extends PreconditionPreparer {
    private static final String WIFI_FEATURE = "android.hardware.wifi";
    @Option(name="wifi-ssid", description="Name of the WiFi network with which to connect")
    protected String mWifiSsid = null;
    @Option(name="wifi-psk", description="The WPA-PSK associated with the wifi-ssid option")
    protected String mWifiPsk = null;

    private boolean hasWifiFeature(ITestDevice device) throws DeviceNotAvailableException {
        String pmFeatures = device.executeShellCommand("pm list features");
        return pmFeatures.contains(WIFI_FEATURE);
    }

    @Override
    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (!this.hasWifiFeature(device)) {
            return;
        }
        if (this.mWifiSsid == null) {
            if (!device.checkConnectivity()) {
                LogUtil.CLog.e((String)"Device has no network connection, no ssid provided, some modules of CTS require an active network connection");
                return;
            }
        } else {
            LogUtil.CLog.i((String)"Attempting connection to \"%s\"", (Object[])new Object[]{this.mWifiSsid});
            if (!device.connectToWifiNetwork(this.mWifiSsid, this.mWifiPsk)) {
                LogUtil.CLog.e((String)"Unable to connect to network \"%s\", some modules of CTSrequire an active network connection", (Object[])new Object[]{this.mWifiSsid});
                return;
            }
        }
        LogUtil.CLog.i((String)"Wifi is connected");
    }
}

