/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.os.StatsLog;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.HostStatsdMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.Sl4aBluetoothUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;

@OptionClass(alias="bluetooth-connection-latency-collector")
public class BluetoothConnectionLatencyCollector
extends HostStatsdMetricCollector {
    private static final String BLUETOOTH_CONNECTION_LATENCY_METRIC_KEY = "bluetooth_connection_latency";
    protected static final ImmutableMap<Integer, String> BLUETOOTH_PROFILES_MAP = ImmutableMap.builder().put(Sl4aBluetoothUtil.BluetoothProfile.HEADSET.getProfile(), "headset").put(Sl4aBluetoothUtil.BluetoothProfile.A2DP.getProfile(), "a2dp").put(Sl4aBluetoothUtil.BluetoothProfile.PAN.getProfile(), "pan").put(Sl4aBluetoothUtil.BluetoothProfile.MAP.getProfile(), "map").put(Sl4aBluetoothUtil.BluetoothProfile.A2DP_SINK.getProfile(), "a2dp_sink").put(Sl4aBluetoothUtil.BluetoothProfile.AVRCP_CONTROLLER.getProfile(), "avrcp_controller").put(Sl4aBluetoothUtil.BluetoothProfile.HEADSET_CLIENT.getProfile(), "headset_client").put(Sl4aBluetoothUtil.BluetoothProfile.PBAP_CLIENT.getProfile(), "pbap_client").put(Sl4aBluetoothUtil.BluetoothProfile.MAP_CLIENT.getProfile(), "map_client").build();

    @Override
    protected void processStatsReport(ITestDevice device, InputStreamSource dataStream, DeviceMetricData runData) {
        try {
            StatsLog.ConfigMetricsReportList reports = StatsLog.ConfigMetricsReportList.parseFrom(dataStream.createInputStream());
            if (reports.getReportsCount() == 0) {
                LogUtil.CLog.w((String)"No stats report is collected");
                return;
            }
            StatsLog.ConfigMetricsReport report = reports.getReports(0);
            if (report.getMetricsCount() == 0) {
                LogUtil.CLog.w((String)"No metrics collected in stats report");
                return;
            }
            StatsLog.StatsLogReport.DurationMetricDataWrapper durationData = report.getMetrics(0).getDurationMetrics();
            if (durationData.getDataCount() == 0) {
                LogUtil.CLog.w((String)"No duration data collected");
                return;
            }
            this.processBluetoothConnectionLatencyData(device, durationData, runData);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to process statsd metric report on device %s, error: %s", (Object[])new Object[]{device.getSerialNumber(), e});
        }
    }

    private void processBluetoothConnectionLatencyData(ITestDevice device, StatsLog.StatsLogReport.DurationMetricDataWrapper durationData, DeviceMetricData runData) {
        for (StatsLog.DurationMetricData metric : durationData.getDataList()) {
            long totalDurationNanos = 0L;
            for (StatsLog.DurationBucketInfo bucket : metric.getBucketInfoList()) {
                totalDurationNanos += bucket.getDurationNanos();
            }
            int bluetoothProfile = metric.getDimensionLeafValuesInWhat(0).getValueInt();
            String metricKey = BLUETOOTH_PROFILES_MAP.containsKey(bluetoothProfile) ? String.join((CharSequence)"_", BLUETOOTH_CONNECTION_LATENCY_METRIC_KEY, BLUETOOTH_PROFILES_MAP.get(bluetoothProfile), "ms") : String.join((CharSequence)"_", BLUETOOTH_CONNECTION_LATENCY_METRIC_KEY, "profile", String.valueOf(bluetoothProfile), "ms");
            long durationMs = totalDurationNanos / 1000000L;
            LogUtil.CLog.d((String)"Processed metric on device %s with key: %s, value %d", (Object[])new Object[]{device.getSerialNumber(), metricKey, durationMs});
            runData.addMetricForDevice(device, metricKey, MetricMeasurement.Metric.newBuilder((MetricMeasurement.Metric)TfMetricProtoUtil.stringToMetric((String)Double.toString(durationMs))));
        }
    }
}

