/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.FilePullerDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

@OptionClass(alias="bluetooth-hci-snoop-log-collector")
public class BluetoothHciSnoopLogCollector
extends FilePullerDeviceMetricCollector {
    private String reportingDir = null;
    public static final String SNOOP_LOG_MODE_PROPERTY = "persist.bluetooth.btsnooplogmode";
    private String initialSnoopLogMode = null;
    private static final int SNOOP_LOG_FILE_HEADER_BYTE_SIZE = 16;

    public void onTestRunStart(DeviceMetricData runData) throws DeviceNotAvailableException {
        this.initialSnoopLogMode = this.getSnoopLogModeProperty();
        this.setSnoopLogModeProperty("full");
        for (ITestDevice device : this.getRealDevices()) {
            this.disableBluetoothService(device);
            this.enableBluetoothService(device);
        }
    }

    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
        this.setSnoopLogModeProperty(this.initialSnoopLogMode);
        for (ITestDevice device : this.getRealDevices()) {
            this.disableBluetoothService(device);
        }
    }

    public void onTestStart(DeviceMetricData testData) throws DeviceNotAvailableException {
        this.deleteReportingDirectory();
        this.createReportingDirectory();
        for (ITestDevice device : this.getRealDevices()) {
            this.executeShellCommand(device, String.format("truncate -s %s %s", 16, "/data/misc/bluetooth/logs/btsnoop_hci.log"));
        }
    }

    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics, TestDescription test) throws DeviceNotAvailableException {
        String testName = test.toString();
        String normalisedTestName = this.normaliseTestName(testName);
        for (ITestDevice device : this.getRealDevices()) {
            String serialNumber = device.getSerialNumber();
            String testSnoopLogFilename = String.format(this.getHciSnoopLogPathFormat(), normalisedTestName, serialNumber);
            this.executeShellCommand(device, String.format("cp -p %s %s", "/data/misc/bluetooth/logs/btsnoop_hci.log", testSnoopLogFilename));
        }
        super.onTestEnd(testData, currentTestCaseMetrics);
    }

    public final void processMetricFile(String key, File metricFile, DeviceMetricData runData) {
        try (FileInputStreamSource source = new FileInputStreamSource(metricFile, true);){
            this.testLog(FileUtil.getBaseName((String)metricFile.getName()), LogDataType.BT_SNOOP_LOG, (InputStreamSource)source);
        }
    }

    public void processMetricDirectory(String key, File metricDirectory, DeviceMetricData runData) {
        if (metricDirectory.listFiles() == null) {
            LogUtil.CLog.e((String)"metricDirectory.listFiles() is null.");
            return;
        }
        for (File file : metricDirectory.listFiles()) {
            if (file.isDirectory()) {
                this.processMetricDirectory(key, file, runData);
                continue;
            }
            this.processMetricFile(key, file, runData);
        }
        FileUtil.recursiveDelete((File)metricDirectory);
    }

    public String getReportingDir() {
        if (this.reportingDir == null) {
            if (this.mDirectoryKeys.size() == 0) {
                LogUtil.CLog.w((String)"No directory key set.");
            } else if (this.mDirectoryKeys.size() > 1) {
                LogUtil.CLog.w((String)"%s directory keys were set.", (Object[])new Object[]{this.mDirectoryKeys.size()});
            }
            this.reportingDir = (String)this.mDirectoryKeys.iterator().next();
        }
        return this.reportingDir;
    }

    private String getHciSnoopLogPathFormat() throws DeviceNotAvailableException {
        return this.getReportingDir() + "/%s-%s-btsnoop_hci.log";
    }

    private void createReportingDirectory() throws DeviceNotAvailableException {
        for (ITestDevice device : this.getRealDevices()) {
            this.executeShellCommand(device, "mkdir -p " + this.getReportingDir());
        }
    }

    private void deleteReportingDirectory() throws DeviceNotAvailableException {
        for (ITestDevice device : this.getRealDevices()) {
            this.executeShellCommand(device, "rm -rf  " + this.getReportingDir());
        }
    }

    private String getSnoopLogModeProperty() throws DeviceNotAvailableException {
        Iterator iterator = this.getRealDevices().iterator();
        if (iterator.hasNext()) {
            ITestDevice device = (ITestDevice)iterator.next();
            return device.getProperty(SNOOP_LOG_MODE_PROPERTY);
        }
        return null;
    }

    private void setSnoopLogModeProperty(String mode) throws DeviceNotAvailableException {
        if (mode == null) {
            LogUtil.CLog.i((String)"mode is null. Using empty string instead.");
            mode = "";
        }
        for (ITestDevice device : this.getRealDevices()) {
            boolean successfullySetPropOnDevice = device.setProperty(SNOOP_LOG_MODE_PROPERTY, mode);
            if (successfullySetPropOnDevice) continue;
            LogUtil.CLog.w((String)"Failed to set property [%s] to [%s] on [%s].", (Object[])new Object[]{SNOOP_LOG_MODE_PROPERTY, mode, device.getSerialNumber()});
        }
    }

    private void disableBluetoothService(ITestDevice device) throws DeviceNotAvailableException {
        this.executeShellCommand(device, "cmd bluetooth_manager disable");
        this.executeShellCommand(device, "cmd bluetooth_manager wait-for-state:STATE_OFF");
    }

    private void enableBluetoothService(ITestDevice device) throws DeviceNotAvailableException {
        this.executeShellCommand(device, "cmd bluetooth_manager enable");
        this.executeShellCommand(device, "cmd bluetooth_manager wait-for-state:STATE_ON");
    }

    protected void executeShellCommand(ITestDevice device, String command) throws DeviceNotAvailableException {
        CommandResult result = device.executeShellV2Command(command);
        if (result.getExitCode() != 0) {
            throw new DeviceRuntimeException("Failed to execute command: " + command, (ErrorIdentifier)DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
    }

    private String normaliseTestName(String testName) {
        return testName.replace("/", "_");
    }
}

