/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.os.AtomsProto;
import com.android.os.StatsLog;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.Message;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.StatsdGenericPostProcessor;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.ProtoUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@OptionClass(alias="statsd-event-metric-processor")
public class StatsdEventMetricPostProcessor
extends StatsdGenericPostProcessor {
    @Option(name="metric-formatter", description="A formatter to format a statsd atom into a key-value pair for a metric. Format: Use the atom field name as key and a 'key=value' string as value, and enclose atom field reference in square brackets, where they will be substituted with the field values in the atom. Example: key: app_start_occurred, value: [type]_startup_[pkg_name]=[windows_drawn_delay_millis]. Additionally, use [_elapsed_timestamp_nanos] for the elapsed_timestamp_nanos field that records when the event occurred. At most one reference to repeated fields in each formatter is supported. Field definitions can be found in the atoms.proto file under frameworks/proto_logging/stats in the source tree.")
    private MultiMap<String, String> mMetricFormatters = new MultiMap();
    private static final Pattern FIELD_REF_PATTERN = Pattern.compile("\\[(?:[a-zA-Z_]+\\.)*(?:[a-zA-Z_]+)\\]");

    @Override
    protected Map<String, MetricMeasurement.Metric.Builder> parseMetricsFromReportList(StatsLog.ConfigMetricsReportList reportList) {
        MultiMap parsedMetrics = new MultiMap();
        for (StatsLog.ConfigMetricsReport report : reportList.getReportsList()) {
            for (StatsLog.StatsLogReport metric : report.getMetricsList()) {
                if (!metric.hasEventMetrics()) continue;
                List<StatsLog.EventMetricData> dataItems = metric.getEventMetrics().getDataList();
                Iterator<StatsLog.EventMetricData> iterator = dataItems.iterator();
                while (iterator.hasNext()) {
                    StatsLog.EventMetricData data;
                    GeneratedMessageV3 atomParent = data = iterator.next();
                    AtomsProto.Atom atom = null;
                    if (data.hasAtom()) {
                        atom = data.getAtom();
                    } else if (data.hasAggregatedAtomInfo()) {
                        atomParent = data.getAggregatedAtomInfo();
                        atom = data.getAggregatedAtomInfo().getAtom();
                    }
                    if (atom == null) continue;
                    Map<Descriptors.FieldDescriptor, Object> atomFields = atom.getAllFields();
                    for (Descriptors.FieldDescriptor fieldDescriptor : atomFields.keySet()) {
                        if (!this.mMetricFormatters.containsKey((Object)fieldDescriptor.getName())) continue;
                        parsedMetrics.putAll(this.getMetricsByFormatters((Message)((Object)atomParent), atom, fieldDescriptor, this.mMetricFormatters.get((Object)fieldDescriptor.getName())));
                    }
                }
            }
        }
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String key : parsedMetrics.keySet()) {
            String value = String.join((CharSequence)",", parsedMetrics.get((Object)key));
            finalMetrics.put(key, TfMetricProtoUtil.stringToMetric((String)value).toBuilder());
        }
        return finalMetrics;
    }

    private MultiMap<String, String> getMetricsByFormatters(Message atomParent, AtomsProto.Atom atom, Descriptors.FieldDescriptor atomField, List<String> formatters) {
        MultiMap metrics = new MultiMap();
        Message atomContent = (Message)atom.getField(atomField);
        for (String formatter : formatters) {
            String keyFormatter = formatter.split("=")[0];
            String valueFormatter = formatter.split("=")[1];
            List<String> metricKeys = this.fillInPlaceholders(keyFormatter, atomParent, atomContent);
            List<String> metricValues = this.fillInPlaceholders(valueFormatter, atomParent, atomContent);
            if (metricKeys.size() > 1 && metricValues.size() > 1) {
                LogUtil.CLog.w((String)"Found repeated fields in both metric key and value in formatting pair %s: %s. This is currently unsupported and could result in meaningless data. Skipping reporting on this pair.", (Object[])new Object[]{atomField.getName(), formatter});
                continue;
            }
            for (String metricKey : metricKeys) {
                for (String metricValue : metricValues) {
                    metrics.put((Object)metricKey, (Object)metricValue);
                }
            }
        }
        return metrics;
    }

    private List<String> fillInPlaceholders(String formatter, Message atomParent, Message atomContent) {
        Matcher matcher = FIELD_REF_PATTERN.matcher(formatter);
        List<String> results = Arrays.asList(formatter);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String fieldReference = placeholder.substring(1, placeholder.length() - 1);
            ArrayList actual = new ArrayList();
            if (fieldReference.startsWith("_")) {
                actual.addAll(ProtoUtil.getNestedFieldFromMessageAsStrings((Message)atomParent, Arrays.asList(fieldReference.substring(1).split("\\."))));
            } else {
                actual.addAll(ProtoUtil.getNestedFieldFromMessageAsStrings((Message)atomContent, Arrays.asList(fieldReference.split("\\."))));
            }
            if (results.size() > 1 && actual.size() > 1) {
                LogUtil.CLog.w((String)"Found repeated fields in both metric key and value in formatter %s. This is currently unsupported and could result in meaningless data. Skipping reporting on this formatter.", (Object[])new Object[]{formatter});
                return new ArrayList<String>();
            }
            List updatedResults = results.stream().flatMap(r -> actual.stream().map(a -> r.replace(placeholder, (CharSequence)a))).collect(Collectors.toList());
            results = updatedResults;
        }
        return results;
    }
}

