/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.DeviceActionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@OptionClass(alias="device-action")
public class DeviceActionTargetPreparer
extends BaseTargetPreparer
implements ITestLoggerReceiver {
    private static final String REPEATED_FLAG_DELIMITER = ", ";
    private static final String FILE_ARG_FORMAT = "file_%s=%s";
    private static final String MAINLINE_MODULES_TAG = "mainline_modules";
    private static final String APKS_ZIPS_TAG = "apks_zips";
    private static final String TRAIN_FOLDER_TAG = "train_folder";
    private static final String ENABLE_ROLLBACK_FLAG = "enable_rollback";
    private static final String DEV_KEY_SIGNED_FLAG = "dev_key_signed";
    @Option(name="da-command", description="Command name of device action.", mandatory=true)
    private DeviceActionUtil.Command mCommand;
    @Option(name="bundletool-jar", description="The file name of the bundletool jar.", mandatory=true)
    File mBundletoolJar;
    @Option(name="device-action-jar", description="The file name of the device action jar.", mandatory=true)
    File mDeviceActionJar;
    @Option(name="enable-rollback", description="Enable rollback if the mainline update fails.")
    private boolean mEnableRollback = true;
    @Option(name="dev-key-signed", description="If the modules are signed by dev keys.")
    private boolean mDevKeySigned = false;
    @Option(name="train-folder", description="The path of the train folder.")
    private File mTrainFolderPath;
    @Option(name="mainline-modules", description="The name of module file to be installed on device. Can be repeated. The file can be apk/apex/apks. If one file is apks, then all files should be apks.")
    private Set<File> mModuleFiles = new HashSet<File>();
    @Option(name="apks-zips", description="The name of zip file containing train apks. Can be repeated.")
    private Set<File> mZipFiles = new HashSet<File>();
    private DeviceActionUtil mDeviceActionUtil;
    private ITestLogger mTestLogger;

    public void setUp(TestInformation testInfo) throws TargetSetupError {
        CommandResult result;
        if (this.mDeviceActionUtil == null) {
            try {
                this.mDeviceActionUtil = DeviceActionUtil.create(this.mDeviceActionJar, this.mBundletoolJar);
            }
            catch (DeviceActionUtil.DeviceActionConfigError e) {
                throw new TargetSetupError("Failed to create DeviceActionUtil", (Throwable)((Object)e), e.getErrorId());
            }
        }
        if ((result = this.performAction(testInfo)) == null) {
            LogUtil.CLog.w((String)"No action performed.");
            return;
        }
        LogUtil.CLog.i((String)result.getStdout());
        LogUtil.CLog.i((String)result.getStderr());
        TargetSetupError error = null;
        try {
            this.mDeviceActionUtil.generateLogFile(result);
            if (this.mTestLogger != null) {
                this.mDeviceActionUtil.saveToLogs(this.mCommand, this.mTestLogger);
            }
        }
        catch (IOException e) {
            error = new TargetSetupError("Failed to save log files.", (Throwable)e, (ErrorIdentifier)InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
        if (result.getExitCode() != 0) {
            error = new TargetSetupError(String.format("Failed to execute device action command %s. The status is %s.", new Object[]{this.mCommand, result.getStatus()}), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_ACTION_EXECUTION_FAILURE);
        } else {
            LogUtil.CLog.i((String)"Device action completed.");
        }
        if (error != null) {
            throw error;
        }
    }

    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
    }

    @VisibleForTesting
    void setDeviceActionUtil(DeviceActionUtil deviceActionUtil) {
        this.mDeviceActionUtil = deviceActionUtil;
    }

    @Nullable
    private CommandResult performAction(TestInformation testInfo) {
        String deviceId = testInfo.getDevice().getSerialNumber();
        switch (this.mCommand) {
            case RESET: {
                return this.reset(deviceId);
            }
            case INSTALL_MAINLINE: {
                return this.installMainline(deviceId);
            }
        }
        return null;
    }

    private CommandResult reset(String deviceId) {
        return this.mDeviceActionUtil.execute(DeviceActionUtil.Command.RESET, deviceId, ImmutableList.of());
    }

    @Nullable
    private CommandResult installMainline(String deviceId) {
        ArrayList<String> args = new ArrayList<String>();
        if (!this.mZipFiles.isEmpty()) {
            args.add(DeviceActionTargetPreparer.createFileArg(APKS_ZIPS_TAG, this.mZipFiles));
        } else if (!this.mModuleFiles.isEmpty()) {
            args.add(DeviceActionTargetPreparer.createFileArg(MAINLINE_MODULES_TAG, this.mModuleFiles));
        } else if (this.mTrainFolderPath != null && this.mTrainFolderPath.exists()) {
            args.add(DeviceActionTargetPreparer.createFileArg(TRAIN_FOLDER_TAG, this.mTrainFolderPath));
        } else {
            LogUtil.CLog.i((String)"No module provided. No mainline update.");
            return null;
        }
        if (this.mEnableRollback) {
            args.add(ENABLE_ROLLBACK_FLAG);
        }
        if (this.mDevKeySigned) {
            args.add(DEV_KEY_SIGNED_FLAG);
        }
        return this.mDeviceActionUtil.execute(DeviceActionUtil.Command.INSTALL_MAINLINE, deviceId, args);
    }

    private static String createFileArg(String tag, Collection<File> files) {
        return files.stream().map(file -> DeviceActionTargetPreparer.createFileArg(tag, file)).collect(Collectors.joining(REPEATED_FLAG_DELIMITER));
    }

    private static String createFileArg(String tag, File file) {
        return String.format(FILE_ARG_FORMAT, tag, file.getAbsolutePath());
    }
}

