/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.concurrent.Semaphore;

@OptionClass(alias="semaphore-token")
public class SemaphoreTokenTargetPreparer
extends BaseTargetPreparer {
    private boolean mTokenAcquired = true;
    static final Semaphore mRunToken = new Semaphore(1);
    private boolean mInvokedTeardown = true;

    public SemaphoreTokenTargetPreparer() {
        this.setDisable(true);
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mInvokedTeardown) {
            try {
                LogUtil.CLog.v((String)"Waiting to acquire run token");
                mRunToken.acquire();
                this.mTokenAcquired = true;
                LogUtil.CLog.v((String)"Token acquired");
            }
            catch (InterruptedException e) {
                this.mTokenAcquired = false;
                LogUtil.CLog.e((Throwable)e);
                LogUtil.CLog.e((String)"Interrupted error during token acquire");
            }
        }
        this.mInvokedTeardown = false;
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        this.mInvokedTeardown = true;
        if (this.mTokenAcquired) {
            LogUtil.CLog.v((String)"Releasing run token");
            mRunToken.drainPermits();
            mRunToken.release();
        } else {
            LogUtil.CLog.v((String)"Did not acquire token, skip releasing run token");
        }
    }
}

