/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.DeviceUpdateTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;

@OptionClass(alias="sideload-ota")
public class SideloadOtaTargetPreparer
extends DeviceUpdateTargetPreparer {
    private static final String SIDELOAD_CMD = "sideload";
    private static final long POST_SIDELOAD_TRANSITION_TIMEOUT = 10000L;
    @Option(name="sideload-ota-package", description="the OTA package to be sideloaded")
    private File mSideloadOtaPackage = null;
    @Option(name="sideload-timeout", description="timeout for sideloading the OTA package", isTimeVal=true)
    private long mSideloadTimeout = 600000L;
    @Option(name="use-auto-reboot", description="whether to use auto reboot after sideload")
    private boolean mUseAutoReboot = false;

    protected File getDeviceUpdateImage() {
        return this.mSideloadOtaPackage;
    }

    protected void preUpdateActions(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        device.rebootIntoSideload(this.mUseAutoReboot);
    }

    protected void postUpdateActions(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mUseAutoReboot) {
            device.waitForDeviceInRecovery(10000L);
            LogUtil.CLog.i((String)"Sideloading completed on %s, rebooting and waiting for boot complete.", (Object[])new Object[]{device.getDeviceDescriptor()});
            device.reboot();
        } else {
            device.waitForDeviceAvailable();
        }
    }

    protected void performDeviceUpdate(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        String filePath = this.getDeviceUpdateImage().getAbsolutePath();
        LogUtil.CLog.i((String)"Sideloading package from %s onto %s", (Object[])new Object[]{filePath, device.getSerialNumber()});
        device.executeAdbCommand(this.mSideloadTimeout, new String[]{SIDELOAD_CMD, filePath});
    }
}

