/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="temperature-throttle-waiter")
public class TemperatureThrottlingWaiter
extends BaseTargetPreparer {
    private static final Pattern TEMPERATURE_RAW_FORMAT_REGEX = Pattern.compile("Result:(\\d+)\\sRaw:(\\w+)");
    private static final Pattern TEMPERATURE_FORMAT_REGEX = Pattern.compile("\\d+");
    private static final Pattern TEMPERATURE_SKIN_FORMAT_PATTERN = Pattern.compile("mValue=([\\d]+.[\\d]+).*mType=3");
    @Option(name="poll-interval", description="Interval in seconds, to poll for device temperature; defaults to 30s")
    private long mPollIntervalSecs = 30L;
    @Option(name="max-wait", description="Max wait time in seconds, for device cool down to target temperature; defaults to 20 minutes")
    private long mMaxWaitSecs = 1200L;
    @Option(name="abort-on-timeout", description="If test should be aborted if device is still  above expected temperature; defaults to false")
    private boolean mAbortOnTimeout = false;
    @Option(name="post-idle-wait", description="Additional time to wait in seconds, after temperature has reached to target; defaults to 120s")
    private long mPostIdleWaitSecs = 120L;
    public static final String DEVICE_TEMPERATURE_FILE_PATH_NAME = "device-temperature-file-path";
    @Option(name="device-temperature-file-path", description="Name of file that contains devicetemperature. Example: /sys/class/hwmon/hwmon1/device/msm_therm")
    private String mDeviceTemperatureFilePath = null;
    public static final String DEVICE_TEMPERATURE_COMMAND_NAME = "device-temperature-command";
    @Option(name="device-temperature-command", description="Command for getting device temperature. If both device-temperature-file-path and device-temperature-command are set, only device-temperature-file-path will be actived. Example: dumpsys thermalservice | grep 'mType=3' | grep Temperature | awk 'END{print}'")
    private String mDeviceTemperatureCommand = "dumpsys thermalservice | grep 'mType=3' | grep Temperature | awk 'END{print}'";
    @Option(name="target-temperature", description="Target Temperature that device should have;defaults to 30c")
    private int mTargetTemperature = 30;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mDeviceTemperatureFilePath == null && this.mDeviceTemperatureCommand == null) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        long start = System.currentTimeMillis();
        long maxWaitMs = this.mMaxWaitSecs * 1000L;
        long intervalMs = this.mPollIntervalSecs * 1000L;
        int deviceTemperature = Integer.MAX_VALUE;
        while (true) {
            if ((deviceTemperature = this.getDeviceTemperature(device)) <= this.mTargetTemperature) {
                LogUtil.CLog.i((String)"Total time elapsed to get to %dc : %ds", (Object[])new Object[]{this.mTargetTemperature, (System.currentTimeMillis() - start) / 1000L});
                break;
            }
            LogUtil.CLog.d((String)"Temperature is still high actual %d/expected %d", (Object[])new Object[]{deviceTemperature, this.mTargetTemperature});
            if (System.currentTimeMillis() - start > maxWaitMs) {
                LogUtil.CLog.w((String)"Temperature is still high, actual %d/expected %d; waiting after %ds", (Object[])new Object[]{deviceTemperature, this.mTargetTemperature, maxWaitMs});
                if (!this.mAbortOnTimeout) break;
                throw new TargetSetupError(String.format("Temperature is still high after wait timeout; actual %d/expected %d", deviceTemperature, this.mTargetTemperature), device.getDeviceDescriptor());
            }
            this.getRunUtil().sleep(intervalMs);
        }
        this.getRunUtil().sleep(this.mPostIdleWaitSecs * 1000L);
        LogUtil.CLog.d((String)"Done waiting, total time elapsed: %ds", (Object[])new Object[]{(System.currentTimeMillis() - start) / 1000L});
    }

    protected int getDeviceTemperature(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        String result = this.executeDeviceTemperatureCommand(device);
        LogUtil.CLog.i((String)String.format("Temperature command output : %s", result));
        if (result == null || result.contains("No such file or directory")) {
            throw new TargetSetupError(String.format("File %s doesn't exist", this.mDeviceTemperatureFilePath), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        return this.parseResult(result, device);
    }

    private String executeDeviceTemperatureCommand(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mDeviceTemperatureFilePath != null) {
            return device.executeShellCommand(String.format("cat %s", this.mDeviceTemperatureFilePath)).trim();
        }
        if (this.mDeviceTemperatureCommand != null) {
            return device.executeShellCommand(this.mDeviceTemperatureCommand).trim();
        }
        return "UNKNOWN";
    }

    private int parseResult(String result, ITestDevice device) throws TargetSetupError {
        Matcher tempRawFormatMatcher = TEMPERATURE_RAW_FORMAT_REGEX.matcher(result);
        if (tempRawFormatMatcher.find()) {
            return Integer.parseInt(tempRawFormatMatcher.group(1));
        }
        Matcher tempFormatMatcher = TEMPERATURE_FORMAT_REGEX.matcher(result);
        if (tempFormatMatcher.find()) {
            return Integer.parseInt(tempFormatMatcher.group());
        }
        Matcher skinFormatMatcher = TEMPERATURE_SKIN_FORMAT_PATTERN.matcher(result);
        if (skinFormatMatcher.find()) {
            return Integer.parseInt(skinFormatMatcher.group(1));
        }
        throw new TargetSetupError(String.format("result content is not as expected. Content : %s", result), device.getDeviceDescriptor());
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

