/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.multi;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.BaseMultiTargetPreparer;
import java.util.HashSet;
import java.util.Set;

@OptionClass(alias="multi-build-merge")
public final class MergeMultiBuildTargetPreparer
extends BaseMultiTargetPreparer {
    @Option(name="src-device", description="The name of the device that will provide the files. As specified in the <device> tag of the configuration.", mandatory=true)
    private String mProvider;
    @Option(name="dest-device", description="The name of the device that will receive the files. As specified in the <device> tag of the configuration.", mandatory=true)
    private String mReceiver;
    @Option(name="key-to-copy", description="The name of the files that needs to be moved.")
    private Set<String> mKeysToMove = new HashSet<String>();
    @Option(name="enforce-copy", description="Throw if a copy of key fails.")
    private boolean mEnforceCopy = false;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IInvocationContext context = testInfo.getContext();
        IBuildInfo providerInfo = context.getBuildInfo(this.mProvider);
        if (providerInfo == null) {
            throw new TargetSetupError(String.format("Could not find a build associated with '%s'", this.mProvider), ((ITestDevice)context.getDevices().get(0)).getDeviceDescriptor());
        }
        IBuildInfo receiverInfo = context.getBuildInfo(this.mReceiver);
        if (receiverInfo == null) {
            throw new TargetSetupError(String.format("Could not find a build associated with '%s'", this.mReceiver), ((ITestDevice)context.getDevices().get(0)).getDeviceDescriptor());
        }
        for (String key : this.mKeysToMove) {
            VersionedFile toBeMoved = providerInfo.getVersionedFile(key);
            if (toBeMoved == null) {
                String error = String.format("Key '%s' did not match any files, ignoring.", key);
                LogUtil.CLog.w((String)error);
                if (!this.mEnforceCopy) continue;
                throw new TargetSetupError(error, (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            if (this.mEnforceCopy && receiverInfo.getFile(key) != null) {
                throw new TargetSetupError(String.format("Failed to copy key '%s' it already exists in receiver info '%s'", key, this.mReceiver), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            receiverInfo.setFile(key, toBeMoved.getFile(), toBeMoved.getVersion());
        }
    }
}

