/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.multi;

import com.android.loganalysis.util.config.OptionClass;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.BaseMultiTargetPreparer;
import com.android.tradefed.util.Sl4aBluetoothUtil;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="bluetooth-multi-target-pairing")
public class PairingMultiTargetPreparer
extends BaseMultiTargetPreparer {
    @Option(name="bt-connection-primary-device", description="The target name of the primary device during BT pairing.", mandatory=true)
    private String mPrimaryDeviceName;
    @Option(name="with-connection", description="Connect the profiles once the devices are paired. If true, given bluetooth profiles will be connected. If false, the connection status is non-deterministic. Devices will be paired but connection will not be done explicitly. The connection status depends on the type of device, i.e. some devices will automatically connect, but some won't.")
    private boolean mConnectDevices = true;
    @Option(name="bt-profile", description="A set of Bluetooth profiles that will be connected if connection is needed. They should be specified as Bluetooth profile name defined in android.bluetooth.BluetoothProfile")
    private Set<Sl4aBluetoothUtil.BluetoothProfile> mProfiles = new HashSet<Sl4aBluetoothUtil.BluetoothProfile>();
    @Option(name="bt-pairing-timeout", description="Set the timeout (default in ms) to wait for two devices to be paired")
    private Duration mPairingTimeout = Duration.ofMinutes(1L).plusSeconds(30L);
    private ITestDevice mPrimaryDevice;
    private ITestDevice mCompanionDevice;
    private Sl4aBluetoothUtil mUtil = new Sl4aBluetoothUtil();

    @VisibleForTesting
    void setBluetoothUtil(Sl4aBluetoothUtil util) {
        this.mUtil = util;
    }

    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.setDeviceInfos(testInformation.getContext().getDeviceBuildMap());
        try {
            LogUtil.CLog.d((String)"Enabling bluetooth on %s", (Object[])new Object[]{this.mPrimaryDevice.getDeviceDescriptor()});
            if (!this.mUtil.enable(this.mPrimaryDevice)) {
                throw new TargetSetupError("Failed to enable Bluetooth", this.mPrimaryDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            LogUtil.CLog.d((String)"Enabling bluetooth on %s", (Object[])new Object[]{this.mCompanionDevice.getDeviceDescriptor()});
            if (!this.mUtil.enable(this.mCompanionDevice)) {
                throw new TargetSetupError("Failed to enable Bluetooth", this.mCompanionDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            this.mUtil.setBtPairTimeout(this.mPairingTimeout);
            LogUtil.CLog.d((String)"Starting pairing bluetooth on %s", (Object[])new Object[]{this.mPrimaryDevice.getDeviceDescriptor()});
            if (!this.mUtil.pair(this.mPrimaryDevice, this.mCompanionDevice)) {
                throw new TargetSetupError("Bluetooth pairing failed.", this.mPrimaryDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_BLUETOOTH_PAIRING);
            }
            LogUtil.CLog.d((String)"Enabling PBAP on %s", (Object[])new Object[]{this.mCompanionDevice.getDeviceDescriptor()});
            if (!this.mUtil.changeProfileAccessPermission(this.mCompanionDevice, this.mPrimaryDevice, Sl4aBluetoothUtil.BluetoothProfile.PBAP, Sl4aBluetoothUtil.BluetoothAccessLevel.ACCESS_ALLOWED)) {
                throw new TargetSetupError("Failed to allow PBAP access", this.mCompanionDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            LogUtil.CLog.d((String)"Enabling PBAP_CLIENT on %s", (Object[])new Object[]{this.mPrimaryDevice.getDeviceDescriptor()});
            if (!this.mUtil.setProfilePriority(this.mPrimaryDevice, this.mCompanionDevice, Collections.singleton(Sl4aBluetoothUtil.BluetoothProfile.PBAP_CLIENT), Sl4aBluetoothUtil.BluetoothPriorityLevel.PRIORITY_ON)) {
                throw new TargetSetupError("Failed to turn on PBAP client priority", this.mPrimaryDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            LogUtil.CLog.d((String)"Connecting to profiles");
            if (this.mConnectDevices && this.mProfiles.size() > 0 && !this.mUtil.connect(this.mPrimaryDevice, this.mCompanionDevice, this.mProfiles)) {
                throw new TargetSetupError("Failed to connect bluetooth profiles", this.mPrimaryDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
        }
        finally {
            this.mUtil.stopSl4a();
        }
    }

    private void setDeviceInfos(Map<ITestDevice, IBuildInfo> deviceInfos) throws TargetSetupError, DeviceNotAvailableException {
        ArrayList<ITestDevice> devices = new ArrayList<ITestDevice>(deviceInfos.keySet());
        if (devices.size() != 2) {
            throw new TargetSetupError("The preparer assumes 2 devices only", ((ITestDevice)devices.get(0)).getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        int primaryIdx = this.mPrimaryDeviceName.equals(((ITestDevice)devices.get(0)).getProductType()) ? 0 : 1;
        this.mPrimaryDevice = (ITestDevice)devices.get(primaryIdx);
        this.mCompanionDevice = (ITestDevice)devices.get(1 - primaryIdx);
    }
}

