/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.GTestBase;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ShellOutputReceiverStream;
import com.android.tradefed.util.TestRunnerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="hostgtest")
public class HostGTest
extends GTestBase
implements IBuildReceiver {
    private static final long DEFAULT_HOST_COMMAND_TIMEOUT_MS = 120000L;
    private IBuildInfo mBuildInfo = null;
    @Option(name="use-updated-shard-retry", description="Whether to use the updated logic for retry with sharding.")
    private boolean mUseUpdatedShardRetry = true;
    private boolean mIncompleteTestFound = false;
    private Set<String> mCurFailedTests = new LinkedHashSet<String>();

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public CommandResult executeHostCommand(String cmd) {
        return this.executeHostCommand(cmd, 120000L);
    }

    public CommandResult executeHostCommand(String cmd, long timeoutMs) {
        String[] cmds = cmd.split("\\s+");
        return RunUtil.getDefault().runTimedCmd(timeoutMs, cmds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult executeHostGTestCommand(File gtestFile, String cmd, long timeoutMs, IShellOutputReceiver receiver, ITestLogger logger) {
        RunUtil runUtil = new RunUtil();
        String[] cmds = cmd.split("\\s+");
        if (this.getShardCount() > 0) {
            if (this.isCollectTestsOnly()) {
                LogUtil.CLog.w((String)"--collect-tests-only option ignores sharding parameters, and will cause each shard to collect all tests.");
            }
            runUtil.setEnvVariable("GTEST_SHARD_INDEX", Integer.toString(this.getShardIndex()));
            runUtil.setEnvVariable("GTEST_TOTAL_SHARDS", Integer.toString(this.getShardCount()));
        }
        runUtil.setRedirectStderrToStdout(true);
        runUtil.setWorkingDir(gtestFile.getParentFile());
        String separator = System.getProperty("path.separator");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(System.getenv("PATH"));
        paths.add(gtestFile.getParentFile().getAbsolutePath());
        String path = paths.stream().distinct().collect(Collectors.joining(separator));
        LogUtil.CLog.d((String)"Using updated $PATH: %s", (Object[])new Object[]{path});
        runUtil.setEnvVariablePriority(IRunUtil.EnvPriority.SET);
        runUtil.setEnvVariable("PATH", path);
        String ldLibraryPath = TestRunnerUtil.getLdLibraryPath((File)gtestFile);
        if (ldLibraryPath != null) {
            runUtil.setEnvVariable("LD_LIBRARY_PATH", ldLibraryPath);
        }
        CommandResult result = null;
        File stdout = null;
        try {
            stdout = FileUtil.createTempFile((String)String.format("%s-output", gtestFile.getName()), (String)".txt");
            try (ShellOutputReceiverStream stream = new ShellOutputReceiverStream(receiver, new FileOutputStream(stdout));){
                result = runUtil.runTimedCmd(timeoutMs, (OutputStream)stream, null, cmds);
            }
            catch (IOException e) {
                throw new RuntimeException("Should never happen, ShellOutputReceiverStream.close is a no-op", e);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                receiver.flush();
                try {
                    FileUtil.writeToFile((String)String.format("\nBinary '%s' still exists: %s", gtestFile, gtestFile.exists()), (File)stdout, (boolean)true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (stdout != null && stdout.length() > 0L) {
                    try (FileInputStreamSource source = new FileInputStreamSource(stdout);){
                        logger.testLog(String.format("%s-output", gtestFile.getName()), LogDataType.TEXT, (InputStreamSource)source);
                    }
                }
                FileUtil.deleteFile((File)stdout);
                throw throwable;
            }
        }
        receiver.flush();
        try {
            FileUtil.writeToFile((String)String.format("\nBinary '%s' still exists: %s", gtestFile, gtestFile.exists()), (File)stdout, (boolean)true);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (stdout != null && stdout.length() > 0L) {
            try (FileInputStreamSource source = new FileInputStreamSource(stdout);){
                logger.testLog(String.format("%s-output", gtestFile.getName()), LogDataType.TEXT, (InputStreamSource)source);
            }
        }
        FileUtil.deleteFile((File)stdout);
        return result;
    }

    @Override
    public String loadFilter(String binaryOnHost) {
        try {
            LogUtil.CLog.i((String)"Loading filter from file for key: '%s'", (Object[])new Object[]{this.getTestFilterKey()});
            String filterFileName = String.format("%s%s", binaryOnHost, ".filter");
            File filterFile = new File(filterFileName);
            if (filterFile.exists()) {
                CommandResult cmdResult = this.executeHostCommand(String.format("cat %s", filterFileName));
                String content = cmdResult.getStdout();
                if (content != null && !content.isEmpty()) {
                    JSONObject filter = new JSONObject(content);
                    String key = this.getTestFilterKey();
                    JSONObject filterObject = filter.getJSONObject(key);
                    return filterObject.getString("filter");
                }
                LogUtil.CLog.e((String)"Error with content of the filter file %s: %s", (Object[])new Object[]{filterFile, content});
            } else {
                LogUtil.CLog.e((String)"Filter file %s not found", (Object[])new Object[]{filterFile});
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        return null;
    }

    private void runTest(IShellOutputReceiver resultParser, File gtestFile, String flags, ITestLogger logger) {
        for (String cmd : this.getBeforeTestCmd()) {
            CommandResult result = this.executeHostCommand(cmd);
            if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
            throw new RuntimeException("'Before test' command failed: " + result.getStderr());
        }
        long maxTestTimeMs = this.getMaxTestTimeMs();
        String cmd = this.getGTestCmdLine(gtestFile.getAbsolutePath(), flags);
        CommandResult testResult = this.executeHostGTestCommand(gtestFile, cmd, maxTestTimeMs, resultParser, logger);
        switch (testResult.getStatus()) {
            case TIMED_OUT: {
                throw new HarnessRuntimeException(String.format("Command run timed out after %d ms", maxTestTimeMs), (ErrorIdentifier)TestErrorIdentifier.TEST_BINARY_TIMED_OUT);
            }
            case EXCEPTION: {
                throw new RuntimeException("Command run failed with exception");
            }
            case FAILED: {
                Integer exitCode = testResult.getExitCode();
                if (exitCode != null && exitCode == 1) break;
                LogUtil.CLog.e((String)"Command run failed with exit code %s", (Object[])new Object[]{exitCode});
                break;
            }
        }
        for (String afterCmd : this.getAfterTestCmd()) {
            CommandResult result = this.executeHostCommand(afterCmd);
            if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
            throw new RuntimeException("'After test' command failed: " + result.getStderr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            Set<File> gTestFiles;
            File testsDir;
            this.mIncompleteTestFound = false;
            this.mCurFailedTests = new LinkedHashSet<String>();
            ArrayList<File> scanDirs = new ArrayList<File>();
            File hostLinkedDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
            if (hostLinkedDir != null) {
                scanDirs.add(hostLinkedDir);
            }
            if ((testsDir = ((DeviceBuildInfo)this.mBuildInfo).getTestsDir()) != null) {
                scanDirs.add(testsDir);
            }
            String moduleName = this.getTestModule();
            try {
                gTestFiles = FileUtil.findFiles((String)moduleName, (IAbi)this.getAbi(), (boolean)false, (File[])scanDirs.toArray(new File[0]));
                gTestFiles = this.applyFileExclusionFilters(gTestFiles);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (gTestFiles == null || gTestFiles.isEmpty()) {
                try {
                    gTestFiles = FileUtil.findFiles((String)(moduleName + ".*"), (IAbi)this.getAbi(), (boolean)false, (File[])scanDirs.toArray(new File[0]));
                    gTestFiles = this.applyFileExclusionFilters(gTestFiles);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (gTestFiles == null || gTestFiles.isEmpty()) {
                throw new RuntimeException(String.format("Fail to find native test %s in directory %s.", moduleName, scanDirs));
            }
            gTestFiles = this.excludeDuplicateFiles(gTestFiles);
            for (File gTestFile : gTestFiles) {
                if (!gTestFile.canExecute()) {
                    LogUtil.CLog.i((String)"%s is not executable! Skipping.", (Object[])new Object[]{gTestFile.getAbsolutePath()});
                    continue;
                }
                listener = this.getGTestListener(listener);
                IShellOutputReceiver resultParser = this.createResultParser(gTestFile.getName(), listener);
                String flags = this.getAllGTestFlags(gTestFile.getName());
                LogUtil.CLog.i((String)"Running gtest %s %s", (Object[])new Object[]{gTestFile.getName(), flags});
                try {
                    this.runTest(resultParser, gTestFile, flags, (ITestLogger)listener);
                }
                finally {
                    if (!(resultParser instanceof GTestResultParser)) continue;
                    if (((GTestResultParser)resultParser).isTestRunIncomplete()) {
                        this.mIncompleteTestFound = true;
                        continue;
                    }
                    this.mCurFailedTests.addAll(((GTestResultParser)resultParser).getFailedTests());
                }
            }
        }
        catch (Throwable t) {
            this.mIncompleteTestFound = true;
            throw t;
        }
        finally {
            if (this.mUseUpdatedShardRetry) {
                this.notifyTestExecution(this.mIncompleteTestFound, this.mCurFailedTests);
            }
        }
    }

    private void reportFailure(ITestInvocationListener listener, String runName, RuntimeException exception) {
        listener.testRunStarted(runName, 0);
        listener.testRunFailed(this.createFailure(exception));
        listener.testRunEnded(0L, new HashMap());
    }

    private FailureDescription createFailure(Exception e) {
        return TestInvocation.createFailureFromException((Throwable)e, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
    }

    private Set<File> applyFileExclusionFilters(Set<File> filesToFilterFrom) {
        LinkedHashSet<File> retFiles = new LinkedHashSet<File>();
        List<String> fileExclusionFilterRegex = this.getFileExclusionFilterRegex();
        for (File file : filesToFilterFrom) {
            boolean matchedRegex = false;
            for (String regex : fileExclusionFilterRegex) {
                if (!file.getPath().matches(regex)) continue;
                LogUtil.CLog.i((String)"File %s matches exclusion file regex %s, skipping", (Object[])new Object[]{file.getPath(), regex});
                matchedRegex = true;
                break;
            }
            if (matchedRegex) continue;
            retFiles.add(file);
        }
        return retFiles;
    }

    private Set<File> excludeDuplicateFiles(Set<File> files) {
        LinkedHashMap<String, File> seen = new LinkedHashMap<String, File>();
        for (File file : files) {
            if (seen.containsKey(file.getName())) {
                LogUtil.CLog.i((String)"File %s already exists in location %s. skipping %s.", (Object[])new Object[]{file.getName(), ((File)seen.get(file.getName())).getAbsolutePath(), file.getAbsolutePath()});
                continue;
            }
            seen.put(file.getName(), file);
        }
        return new LinkedHashSet<File>(seen.values());
    }
}

