/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.testtype.DeviceTestResult;
import com.android.tradefed.testtype.junit4.CarryInterruptedException;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class JUnitRunUtil {
    public static boolean runTest(ITestInvocationListener listener, Test junitTest) throws DeviceNotAvailableException {
        return JUnitRunUtil.runTest(listener, junitTest, junitTest.getClass().getName());
    }

    public static boolean runTest(ITestInvocationListener listener, Test junitTest, String runName) throws DeviceNotAvailableException {
        return JUnitRunUtil.runTest(listener, junitTest, runName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runTest(ITestInvocationListener listener, Test junitTest, String runName, TestInformation testInfo) throws DeviceNotAvailableException {
        if (junitTest.countTestCases() == 0) {
            return false;
        }
        listener.testRunStarted(runName, junitTest.countTestCases());
        long startTime = System.currentTimeMillis();
        JUnitToInvocationResultForwarder resultForwarder = new JUnitToInvocationResultForwarder(listener);
        DeviceTestResult result = new DeviceTestResult();
        result.setTestInfo(testInfo);
        result.addListener((TestListener)resultForwarder);
        try {
            junitTest.run((TestResult)result);
        }
        catch (DeviceTestResult.RuntimeDeviceNotAvailableException e) {
            listener.testRunFailed(e.getDeviceException().getMessage());
            throw e.getDeviceException();
        }
        catch (CarryInterruptedException e) {
            listener.testRunFailed("Test Phase Timeout Reached.");
        }
        finally {
            listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap());
        }
        return true;
    }
}

