/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.binary;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.binary.ExecutableBaseTest;
import com.android.tradefed.util.AdbUtils;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TestRunnerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

@OptionClass(alias="executable-host-test")
public class ExecutableHostTest
extends ExecutableBaseTest {
    private static final String ANDROID_SERIAL = "ANDROID_SERIAL";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String LOG_STDOUT_TAG = "-binary-stdout-";
    private static final String LOG_STDERR_TAG = "-binary-stderr-";
    @Option(name="relative-path-execution", description="Some scripts assume a relative location to their tests file, this allows to execute with that relative location.")
    private boolean mExecuteRelativeToScript = false;

    @Override
    public String findBinary(String binary) {
        File bin = new File(binary);
        if (bin.exists()) {
            return bin.getAbsolutePath();
        }
        if (this.getTestInfo().getBuildInfo() instanceof IDeviceBuildInfo) {
            IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)this.getTestInfo().getBuildInfo();
            File testsDir = deviceBuild.getTestsDir();
            ArrayList<File> scanDirs = new ArrayList<File>();
            File targetTestCases = deviceBuild.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
            if (targetTestCases != null) {
                scanDirs.add(targetTestCases);
            }
            if (testsDir != null) {
                scanDirs.add(testsDir);
            }
            try {
                File src = FileUtil.findFile((String)binary, (IAbi)this.getAbi(), (File[])scanDirs.toArray(new File[0]));
                if (src != null) {
                    return src.getAbsolutePath();
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e((String)"Failed to find test files from directory.");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBinary(String binaryPath, ITestInvocationListener listener, TestDescription description) throws DeviceNotAvailableException, IOException {
        IRunUtil runUtil = this.createRunUtil();
        runUtil.setRedirectStderrToStdout(true);
        if (!(this.getTestInfo().getDevice().getIDevice() instanceof StubDevice)) {
            runUtil.setEnvVariable(ANDROID_SERIAL, this.getTestInfo().getDevice().getSerialNumber());
        }
        String ldLibraryPath = TestRunnerUtil.getLdLibraryPath((File)new File(binaryPath));
        String cwd = new File(binaryPath).getParentFile().getAbsolutePath();
        ldLibraryPath = ldLibraryPath != null ? String.format("%s%s%s", ldLibraryPath, File.pathSeparator, cwd) : cwd;
        runUtil.setEnvVariable(LD_LIBRARY_PATH, ldLibraryPath);
        AdbUtils.updateAdb(this.getTestInfo(), runUtil, this.getAdbPath());
        FileUtil.chmodRWXRecursively((File)new File(binaryPath));
        ArrayList<String> command = new ArrayList<String>();
        String scriptName = new File(binaryPath).getName();
        if (this.mExecuteRelativeToScript) {
            String parentDir = new File(binaryPath).getParent();
            command.add("bash");
            command.add("-c");
            command.add(String.format("pushd %s; ./%s;", parentDir, scriptName));
        } else {
            command.add(binaryPath);
        }
        File stdout = FileUtil.createTempFile((String)(scriptName + LOG_STDOUT_TAG), (String)".txt");
        File stderr = FileUtil.createTempFile((String)(scriptName + LOG_STDERR_TAG), (String)".txt");
        try (FileOutputStream stdoutStream = new FileOutputStream(stdout);
             FileOutputStream stderrStream = new FileOutputStream(stderr);){
            CommandResult res = runUtil.runTimedCmd(this.getTimeoutPerBinaryMs(), (OutputStream)stdoutStream, (OutputStream)stderrStream, command.toArray(new String[0]));
            if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
                TestRecordProto.FailureStatus status = TestRecordProto.FailureStatus.TEST_FAILURE;
                String errorMessage = FileUtil.readStringFromFile((File)stdout);
                if (CommandStatus.TIMED_OUT.equals((Object)res.getStatus())) {
                    errorMessage = errorMessage + "\nTimeout.";
                    status = TestRecordProto.FailureStatus.TIMED_OUT;
                }
                if (res.getExitCode() != null) {
                    errorMessage = errorMessage + String.format("\nExit Code: %s", res.getExitCode());
                }
                listener.testFailed(description, FailureDescription.create((String)errorMessage).setFailureStatus(status));
            }
        }
        finally {
            this.logFile(stdout, (ITestLogger)listener);
            this.logFile(stderr, (ITestLogger)listener);
        }
        if (!(this.getTestInfo().getDevice().getIDevice() instanceof StubDevice)) {
            LogUtil.CLog.d((String)"Checking whether device is still online after %s", (Object[])new Object[]{binaryPath});
            try {
                this.getTestInfo().getDevice().waitForDeviceAvailable();
            }
            catch (DeviceNotAvailableException e) {
                FailureDescription failure = FailureDescription.create((String)String.format("Device became unavailable after %s.", binaryPath), (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.LOST_SYSTEM_UNDER_TEST).setErrorIdentifier((ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE).setCause((Throwable)e);
                listener.testRunFailed(failure);
                throw e;
            }
        }
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    String getAdbPath() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
    }

    private void logFile(File logFile, ITestLogger logger) {
        try (FileInputStreamSource source = new FileInputStreamSource(logFile, true);){
            logger.testLog(logFile.getName(), LogDataType.TEXT, (InputStreamSource)source);
        }
    }
}

