/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.testtype.HostTest;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.ISetOptionReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import java.util.ArrayList;
import java.util.List;
import junitparams.JUnitParamsRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DeviceParameterizedRunner
extends JUnitParamsRunner
implements IAbiReceiver,
ISetOptionReceiver,
ITestInformationReceiver {
    @Option(name="set-option", description="Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map. Values that contain \":\" or \"=\" can be escaped with a backslash. A particular class can be targeted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"")
    private List<String> mKeyValueOptions = new ArrayList<String>();
    private TestInformation mTestInformation;
    private IAbi mAbi;

    public DeviceParameterizedRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object testObj) {
        if (testObj instanceof IDeviceTest) {
            ((IDeviceTest)testObj).setDevice(this.mTestInformation.getDevice());
        }
        if (testObj instanceof IBuildReceiver) {
            ((IBuildReceiver)testObj).setBuild(this.mTestInformation.getBuildInfo());
        }
        if (testObj instanceof IAbiReceiver) {
            ((IAbiReceiver)testObj).setAbi(this.mAbi);
        }
        if (testObj instanceof IInvocationContextReceiver) {
            ((IInvocationContextReceiver)testObj).setInvocationContext(this.mTestInformation.getContext());
        }
        if (testObj instanceof ITestInformationReceiver) {
            ((ITestInformationReceiver)testObj).setTestInformation(this.mTestInformation);
        }
        HostTest.setOptionToLoadedObject(testObj, this.mKeyValueOptions);
        return super.methodInvoker(method, testObj);
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }
}

