/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import com.android.tradefed.testtype.mobly.MoblyYamlResultParser;
import com.android.tradefed.util.AdbUtils;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.Pair;
import com.android.tradefed.util.PythonVirtualenvHelper;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.env.EnvScalarConstructor;

@OptionClass(alias="mobly-host")
public class MoblyBinaryHostTest
implements IRemoteTest,
IDeviceTest,
IBuildReceiver,
ITestFilterReceiver,
IShardableTest {
    private static final String ANDROID_SERIAL_VAR = "ANDROID_SERIAL";
    private static final String MOBLY_TEST_SUMMARY = "test_summary.yaml";
    @Option(name="mobly-par-file-name", description="The binary names inside the build info to run.")
    private Set<String> mBinaryNames = new HashSet<String>();
    @Option(name="mobly-binaries", description="The full path to a runnable python binary. Can be repeated.")
    private Set<File> mBinaries = new HashSet<File>();
    @Option(name="mobly-test-timeout", description="The timeout limit of a single Mobly test binary.", isTimeVal=true)
    private long mTestTimeout = 20000L;
    @Option(name="inject-android-serial", description="Whether or not to pass an ANDROID_SERIAL variable to the process.")
    private boolean mInjectAndroidSerialVar = true;
    @Option(name="mobly-options", description="Option string to be passed to the binary when running")
    private List<String> mTestOptions = new ArrayList<String>();
    @Option(name="mobly-config-file-name", description="Mobly config file name. If set, will append '--config=<config file path>' to the command for running binary.")
    private String mConfigFileName;
    @Option(name="mobly-wildcard-config", description="Use wildcard config. If set and 'mobly-config-file-name' is not set, use wildcard config with all allocted devices.")
    private boolean mWildcardConfig = true;
    @Option(name="test-bed", description="Name of the test bed to run the tests.If set, will append '--test_bed=<test bed name>' to the command for running binary.")
    private String mTestBed;
    @Option(name="mobly-std-log", description="Print mobly logs to standard outputs")
    private boolean mStdLog = false;
    private ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private File mLogDir;
    private TestInformation mTestInfo;
    private IRunUtil mRunUtil;
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    private int shardIndex = 0;
    private int totalShards = 1;

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public Collection<IRemoteTest> split(int shardCountHint) {
        if (shardCountHint <= 1) {
            return null;
        }
        ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(shardCountHint);
        int i = 0;
        while (i < shardCountHint) {
            MoblyBinaryHostTest shard = new MoblyBinaryHostTest();
            shard.addAllIncludeFilters(this.getIncludeFilters());
            shard.addAllExcludeFilters(this.getExcludeFilters());
            try {
                OptionCopier.copyOptions((Object)this, (Object)shard);
            }
            catch (ConfigurationException e) {
                LogUtil.CLog.e((String)"Failed to copy options: %s", (Object[])new Object[]{e.getMessage()});
            }
            shard.shardIndex = i++;
            shard.totalShards = shardCountHint;
            shards.add(shard);
        }
        return shards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(TestInformation testInfo, ITestInvocationListener listener) {
        this.mTestInfo = testInfo;
        this.mBuildInfo = this.mTestInfo.getBuildInfo();
        this.mDevice = this.mTestInfo.getDevice();
        List<File> parFilesList = this.findParFiles(listener);
        File venvDir = this.mBuildInfo.getFile("VIRTUAL_ENV");
        if (venvDir != null && venvDir.exists()) {
            PythonVirtualenvHelper.activate(this.getRunUtil(), venvDir);
        } else {
            LogUtil.CLog.d((String)"No virtualenv configured.");
        }
        for (File parFile : parFilesList) {
            if (!parFile.exists()) {
                LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{parFile.getAbsolutePath()});
                continue;
            }
            parFile.setExecutable(true);
            try {
                this.runSingleParFile(parFile.getAbsolutePath(), parFile.getName(), listener);
            }
            finally {
                this.reportLogs(this.getLogDir(), listener);
            }
        }
    }

    private List<File> findParFiles(ITestInvocationListener listener) {
        ArrayList<File> files = new ArrayList<File>();
        for (String binaryName : this.mBinaryNames) {
            File res = null;
            try {
                res = this.mTestInfo.getDependencyFile(binaryName, false);
                files.add(res);
            }
            catch (FileNotFoundException e) {
                this.reportFailure(listener, binaryName, "Couldn't find Mobly test binary " + binaryName);
            }
        }
        files.addAll(this.mBinaries);
        return files;
    }

    protected Optional<Pair<List<String>, List<String>>> filterTests(String[] testListLines, String runName, ITestInvocationListener listener) {
        String invalidExcludeFilters;
        String invalidIncludeFilters;
        List includeFilters = this.getIncludeFilters().stream().map(x$0 -> new TestFilter((String)x$0)).collect(Collectors.toList());
        List excludeFilters = this.getExcludeFilters().stream().map(x$0 -> new TestFilter((String)x$0)).collect(Collectors.toList());
        ArrayList<String> tests = new ArrayList<String>();
        ArrayList<String> includedTests = new ArrayList<String>();
        String topTestClassName = "";
        for (String line : testListLines) {
            if (line.startsWith("==========> ")) {
                topTestClassName = line.substring(12, line.length() - 12);
                continue;
            }
            if (!line.startsWith("test_") && !line.contains(".test_")) continue;
            String testClassName = topTestClassName;
            String testName = line;
            boolean included = includeFilters.stream().filter(filter -> filter.match(testClassName, testName, false)).count() > 0L;
            boolean excluded = excludeFilters.stream().filter(filter -> filter.match(testClassName, testName, true)).count() > 0L;
            tests.add(testName);
            if (excluded || !included && !includeFilters.isEmpty()) continue;
            includedTests.add(testName);
        }
        if (!includeFilters.isEmpty() && !(invalidIncludeFilters = includeFilters.stream().filter(filter -> !filter.isMatched()).map(filter -> filter.toString()).collect(Collectors.joining(", "))).isEmpty()) {
            this.reportFailure(listener, runName, "Invalid include filters: [" + invalidIncludeFilters + "]");
            return Optional.empty();
        }
        if (!excludeFilters.isEmpty() && !(invalidExcludeFilters = excludeFilters.stream().filter(filter -> !filter.isMatched()).map(filter -> filter.toString()).collect(Collectors.joining(", "))).isEmpty()) {
            this.reportFailure(listener, runName, "Invalid exclude filters: [" + invalidExcludeFilters + "]");
            return Optional.empty();
        }
        return Optional.of(new Pair(tests, includedTests));
    }

    private void runSingleParFile(String parFilePath, String runName, ITestInvocationListener listener) {
        CommandResult list_result;
        if (this.mInjectAndroidSerialVar) {
            this.getRunUtil().setEnvVariable(ANDROID_SERIAL_VAR, this.getDevice().getSerialNumber());
        }
        AdbUtils.updateAdb(this.mTestInfo, this.getRunUtil(), this.getAdbPath());
        String configPath = null;
        if (this.mConfigFileName != null || this.mWildcardConfig) {
            try {
                File configFile = null;
                if (this.mConfigFileName != null) {
                    configFile = this.mTestInfo.getDependencyFile(this.mConfigFileName, false);
                }
                configPath = this.updateTemplateConfigFile(configFile);
            }
            catch (FileNotFoundException e) {
                this.reportFailure(listener, runName, "Couldn't find Mobly config file " + this.mConfigFileName);
                return;
            }
        }
        if (!CommandStatus.SUCCESS.equals((Object)(list_result = this.getRunUtil().runTimedCmd(60000L, new String[]{parFilePath, "--", "--list_tests"})).getStatus())) {
            String message = CommandStatus.TIMED_OUT.equals((Object)list_result.getStatus()) ? "Unable to list tests from the python binary: Timed out" : "Unable to list tests from the python binary\nstdout: " + list_result.getStdout() + "\nstderr: " + list_result.getStderr();
            this.reportFailure(listener, runName, message);
            return;
        }
        Optional<Pair<List<String>, List<String>>> filteredTests = this.filterTests(list_result.getStdout().split(System.lineSeparator()), runName, listener);
        if (filteredTests.isEmpty()) {
            return;
        }
        List allTests = (List)filteredTests.get().first;
        List<String> includedTests = (List<String>)filteredTests.get().second;
        LogUtil.CLog.d((String)"All tests: %s", (Object[])new Object[]{allTests});
        LogUtil.CLog.d((String)"Included tests: %s", (Object[])new Object[]{includedTests});
        int chunkSize = includedTests.size() / this.totalShards;
        if (includedTests.size() % this.totalShards > 0) {
            ++chunkSize;
        }
        int startIndex = this.shardIndex * chunkSize;
        int endIndex = this.totalShards == 1 || this.shardIndex == this.totalShards - 1 ? includedTests.size() : (this.shardIndex + 1) * chunkSize;
        includedTests = includedTests.subList(startIndex, endIndex);
        int testCount = includedTests.size();
        long startTime = System.currentTimeMillis();
        listener.testRunStarted(runName, testCount);
        if (testCount == 0) {
            listener.testRunEnded(0L, new HashMap());
            return;
        }
        if (includedTests.size() == allTests.size()) {
            includedTests.clear();
        }
        String[] command = this.buildCommandLineArray(parFilePath, configPath, includedTests);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CompletableFuture<CommandResult> future = CompletableFuture.supplyAsync(() -> {
            if (this.isStdLogging()) {
                return this.getRunUtil().runTimedCmd(this.getTestTimeout(), (OutputStream)System.out, (OutputStream)System.err, command);
            }
            return this.getRunUtil().runTimedCmd(this.getTestTimeout(), command);
        }, executor);
        MoblyYamlResultParser parser = new MoblyYamlResultParser(listener);
        File yamlSummaryFile = null;
        FileInputStream inputStream = null;
        boolean reportRunFailed = true;
        while (!future.isDone() && yamlSummaryFile == null) {
            yamlSummaryFile = FileUtil.findFile((File)this.getLogDir(), (String)MOBLY_TEST_SUMMARY);
            if (yamlSummaryFile == null) continue;
            try {
                inputStream = new FileInputStream(yamlSummaryFile);
            }
            catch (FileNotFoundException ex) {
                listener.testRunFailed(ex.toString());
                reportRunFailed = false;
            }
        }
        if (inputStream != null) {
            while (!future.isDone()) {
                this.processYamlTestResults(inputStream, parser, listener, runName);
            }
            if (this.processYamlTestResults(inputStream, parser, listener, runName)) {
                reportRunFailed = false;
            } else {
                LogUtil.CLog.e((String)"Did not get a complete summary file from python binary.");
                reportRunFailed = !parser.getRunFailed();
            }
            StreamUtil.close((Closeable)inputStream);
        }
        try {
            CommandResult result = future.get();
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus()) && reportRunFailed) {
                listener.testRunFailed(result.getStderr());
            }
        }
        catch (InterruptedException ex) {
            listener.testRunFailed(ex.toString());
        }
        catch (ExecutionException ex) {
            listener.testRunFailed(ex.toString());
        }
        executor.shutdownNow();
        listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap());
    }

    protected boolean processYamlTestResults(InputStream inputStream, MoblyYamlResultParser parser, ITestInvocationListener listener, String runName) {
        try {
            return parser.parse(inputStream);
        }
        catch (MoblyYamlResultHandlerFactory.InvalidResultTypeException | IOException | IllegalAccessException | InstantiationException ex) {
            LogUtil.CLog.e((String)("Failed to parse the result file.\n" + ex));
            return false;
        }
    }

    private String updateTemplateConfigFile(File templateConfig) throws HarnessRuntimeException {
        InputStream inputStream = null;
        FileWriter fileWriter = null;
        File localConfigFile = new File(this.getLogDir(), "local_config.yaml");
        try {
            if (templateConfig != null) {
                inputStream = new FileInputStream(templateConfig);
            } else {
                String configString = "TestBeds:\n- Name: TestBed\n  Controllers:\n    AndroidDevice: '*'\n";
                inputStream = new ByteArrayInputStream(configString.getBytes());
            }
            fileWriter = new FileWriter(localConfigFile);
            this.updateConfigFile(inputStream, fileWriter);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Exception in creating local config file: %s", ex);
            }
            catch (Throwable throwable) {
                StreamUtil.close(inputStream);
                StreamUtil.close(fileWriter);
                throw throwable;
            }
        }
        StreamUtil.close((Closeable)inputStream);
        StreamUtil.close((Closeable)fileWriter);
        return localConfigFile.getAbsolutePath();
    }

    protected void updateConfigFile(InputStream configInputStream, Writer writer) throws HarnessRuntimeException {
        int index;
        Yaml yaml = new Yaml((BaseConstructor)new EnvScalarConstructor(){

            public String getEnv(String key) {
                return MoblyBinaryHostTest.this.mTestInfo.properties().get(key);
            }
        });
        yaml.addImplicitResolver(EnvScalarConstructor.ENV_TAG, EnvScalarConstructor.ENV_FORMAT, "$");
        Map configMap = (Map)yaml.load(configInputStream);
        LogUtil.CLog.d((String)"Loaded yaml config: \n%s", (Object[])new Object[]{configMap});
        List testBedList = (List)configMap.get("TestBeds");
        Map targetTb = null;
        if (this.getTestBed() == null) {
            targetTb = (Map)testBedList.get(0);
        } else {
            for (Object tb : testBedList) {
                Map tbMap = (Map)tb;
                String tbName = (String)tbMap.get("Name");
                if (!tbName.equalsIgnoreCase(this.getTestBed())) continue;
                targetTb = tbMap;
                break;
            }
        }
        if (targetTb == null) {
            throw new HarnessRuntimeException(String.format("Fail to find specified test bed: %s.", this.getTestBed()), (ErrorIdentifier)TestErrorIdentifier.UNEXPECTED_MOBLY_BEHAVIOR);
        }
        List devices = this.getTestInfo().getDevices();
        Map controllerMap = (Map)targetTb.get("Controllers");
        Object androidDeviceValue = controllerMap.get("AndroidDevice");
        ArrayList androidDeviceList = null;
        if (androidDeviceValue instanceof List) {
            androidDeviceList = (ArrayList)controllerMap.get("AndroidDevice");
            if (devices.size() != androidDeviceList.size()) {
                throw new HarnessRuntimeException(String.format("Device count mismatch (configured: %s vs allocated: %s)", androidDeviceList.size(), devices.size()), (ErrorIdentifier)TestErrorIdentifier.UNEXPECTED_MOBLY_BEHAVIOR);
            }
            for (index = 0; index < devices.size(); ++index) {
                Map deviceMap = (Map)androidDeviceList.get(index);
                deviceMap.put("serial", ((ITestDevice)devices.get(index)).getSerialNumber());
            }
        } else if ("*".equals(androidDeviceValue)) {
            androidDeviceList = new ArrayList();
            controllerMap.put("AndroidDevice", androidDeviceList);
            for (index = 0; index < devices.size(); ++index) {
                HashMap<String, String> deviceMap = new HashMap<String, String>();
                androidDeviceList.add(deviceMap);
                deviceMap.put("serial", ((ITestDevice)devices.get(index)).getSerialNumber());
            }
        } else if (androidDeviceValue == null) {
            LogUtil.CLog.d((String)"No Android device provided.");
        } else {
            throw new HarnessRuntimeException(String.format("Unsupported value for AndroidDevice: %s", androidDeviceValue), (ErrorIdentifier)TestErrorIdentifier.UNEXPECTED_MOBLY_BEHAVIOR);
        }
        HashMap<String, String> paramsMap = (HashMap<String, String>)configMap.get("MoblyParams");
        if (paramsMap == null) {
            paramsMap = new HashMap<String, String>();
            configMap.put("MoblyParams", paramsMap);
        }
        paramsMap.put("LogPath", this.getLogDirAbsolutePath());
        yaml.dump((Object)configMap, writer);
    }

    private File getLogDir() {
        if (this.mLogDir == null) {
            try {
                this.mLogDir = FileUtil.createTempDir((String)"host_tmp_mobly");
            }
            catch (IOException ex) {
                LogUtil.CLog.e((String)"Failed to create temp dir with prefix host_tmp_mobly: %s", (Object[])new Object[]{ex});
            }
            LogUtil.CLog.d((String)"Mobly log path: %s", (Object[])new Object[]{this.mLogDir.getAbsolutePath()});
        }
        return this.mLogDir;
    }

    private void reportFailure(ITestInvocationListener listener, String runName, String errorMessage) {
        listener.testRunStarted(runName, 0);
        FailureDescription description = FailureDescription.create((String)errorMessage, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
        listener.testRunFailed(description);
        listener.testRunEnded(0L, new HashMap());
    }

    private Set<String> cleanFilters(List<String> filters) {
        LinkedHashSet<String> new_filters = new LinkedHashSet<String>();
        for (String filter : filters) {
            new_filters.add(filter.replace("#", "."));
        }
        return new_filters;
    }

    protected String getLogDirAbsolutePath() {
        return this.getLogDir().getAbsolutePath();
    }

    protected File getLogDirFile() {
        return this.mLogDir;
    }

    String getTestBed() {
        return this.mTestBed;
    }

    boolean isStdLogging() {
        return this.mStdLog;
    }

    TestInformation getTestInfo() {
        return this.mTestInfo;
    }

    protected String[] buildCommandLineArray(String filePath, String configPath) {
        return this.buildCommandLineArray(filePath, configPath, new ArrayList<String>());
    }

    protected String[] buildCommandLineArray(String filePath, String configPath, List<String> tests) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(filePath);
        commandLine.add("--");
        if (configPath != null) {
            commandLine.add("--config=" + configPath);
        }
        if (this.getTestBed() != null) {
            commandLine.add("--test_bed=" + this.getTestBed());
        }
        for (ITestDevice device : this.getTestInfo().getDevices()) {
            commandLine.add("--device_serial=" + device.getSerialNumber());
        }
        commandLine.add("--log_path=" + this.getLogDirAbsolutePath());
        if (!tests.isEmpty()) {
            commandLine.add("--tests");
            commandLine.addAll(this.cleanFilters(tests));
        }
        commandLine.addAll(this.getTestOptions());
        return commandLine.toArray(new String[0]);
    }

    protected void reportLogs(File logDir, ITestInvocationListener listener) {
        for (File subFile : logDir.listFiles()) {
            if (subFile.isDirectory()) {
                this.reportLogs(subFile, listener);
                continue;
            }
            if (!subFile.exists()) continue;
            try (FileInputStreamSource dataStream = new FileInputStreamSource(subFile, true);){
                String cleanName = subFile.getName().replace(",", "_");
                LogDataType type = LogDataType.TEXT;
                if (cleanName.contains("trace")) {
                    type = LogDataType.PERFETTO;
                }
                if (cleanName.contains("logcat")) {
                    type = LogDataType.LOGCAT;
                }
                if (cleanName.contains("btsnoop")) {
                    type = LogDataType.BT_SNOOP_LOG;
                }
                listener.testLog(cleanName, type, (InputStreamSource)dataStream);
            }
        }
        FileUtil.recursiveDelete((File)logDir);
        this.mLogDir = null;
    }

    List<String> getTestOptions() {
        return this.mTestOptions;
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    String getAdbPath() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }

    private final class TestFilter {
        public String mFilter;
        public String mTestClassName = "";
        public String mTestName = "";
        public boolean mMatched = false;

        public TestFilter(String filter) {
            this.mFilter = filter;
            if (this.mFilter.startsWith("test_")) {
                this.mTestName = this.mFilter;
            } else {
                String[] split = this.mFilter.split("#", 2);
                if (split.length != 2) {
                    this.mTestClassName = this.mFilter;
                } else {
                    this.mTestClassName = split[0];
                    this.mTestName = split[1];
                }
            }
        }

        public boolean match(String testClassName, String testName, boolean exact) {
            if (this.mTestName.isEmpty() && this.mTestClassName.isEmpty()) {
                return false;
            }
            if (!this.mTestClassName.isEmpty() && !this.mTestClassName.equals(testClassName)) {
                return false;
            }
            if (!this.mTestName.isEmpty()) {
                if (testName.startsWith(testClassName)) {
                    testName = testName.substring(testClassName.length() + 1);
                }
                if (exact && !testName.equals(this.mTestName)) {
                    return false;
                }
                if (!exact && !testName.startsWith(this.mTestName)) {
                    return false;
                }
            }
            this.mMatched = true;
            return true;
        }

        public boolean isMatched() {
            return this.mMatched;
        }

        public String toString() {
            return this.mFilter;
        }
    }
}

